/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPages;
import com.lowagie.text.pdf.PdfResources;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfXObjectDictionary;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class PdfWriter
extends DocWriter {
    private static byte[] HEADER = DocWriter.getISOBytes("%PDF-1.3\n%\u00e0\u00e1\u00e2\u00e3\n");
    private static final int OFFSET = HEADER.length;
    private static final int ROOT = 1;
    private static final PdfIndirectReference ROOTREFERENCE = new PdfIndirectReference(6, 1);
    protected PdfPages root = new PdfPages();
    protected PdfXObjectDictionary imageDictionary = new PdfXObjectDictionary();
    protected HashMap formXObjects = new HashMap();
    protected int formXObjectsCounter = 1;
    protected int fontNumber = 1;
    protected PdfContentByte directContent;
    protected PdfContentByte directContentUnder;
    protected HashMap documentFonts = new HashMap();
    private PdfBody body = new PdfBody(OFFSET);
    private PdfDocument pdf;
    private PdfPageEvent pageEvent;

    protected PdfWriter(PdfDocument pdfDocument, OutputStream outputStream) {
        super(pdfDocument, outputStream);
        this.pdf = pdfDocument;
        this.directContent = new PdfContentByte(this);
        this.directContentUnder = new PdfContentByte(this);
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream, DocListener docListener) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        pdfDocument.addDocListener(docListener);
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public PdfIndirectReference add(PdfPage pdfPage, PdfContents pdfContents) throws PdfException {
        if (!this.open) {
            throw new PdfException("The document isn't open.");
        }
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfContents);
        try {
            pdfIndirectObject.writeTo(this.os);
            this.os.flush();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        pdfPage.add(pdfIndirectObject.getIndirectReference());
        pdfPage.setParent(ROOTREFERENCE);
        PdfIndirectObject pdfIndirectObject2 = this.body.add(pdfPage);
        try {
            pdfIndirectObject2.writeTo(this.os);
            this.os.flush();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        this.root.add(pdfIndirectObject2.getIndirectReference());
        return pdfIndirectObject2.getIndirectReference();
    }

    public PdfIndirectReference add(PdfImage pdfImage) throws PdfException {
        if (!this.imageDictionary.contains(pdfImage)) {
            PdfIndirectObject pdfIndirectObject = this.body.add(pdfImage);
            try {
                pdfIndirectObject.writeTo(this.os);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
            this.imageDictionary.put(pdfImage.name(), pdfIndirectObject.getIndirectReference());
            return pdfIndirectObject.getIndirectReference();
        }
        return (PdfIndirectReference)this.imageDictionary.get(pdfImage.name());
    }

    public PdfIndirectReference getImageReference(PdfName pdfName) {
        return (PdfIndirectReference)this.imageDictionary.get(pdfName);
    }

    public PdfIndirectReference add(PdfOutline pdfOutline) throws PdfException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfOutline);
        try {
            pdfIndirectObject.writeTo(this.os);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        return pdfIndirectObject.getIndirectReference();
    }

    public void open() {
        try {
            this.os.write(HEADER);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        this.pdf.close();
        try {
            PdfIndirectObject pdfIndirectObject;
            Object object;
            Iterator iterator = this.formXObjects.keySet().iterator();
            while (iterator.hasNext()) {
                object = (PdfTemplate)iterator.next();
                pdfIndirectObject = this.body.add(((PdfTemplate)object).getFormXObject(), ((PdfTemplate)object).getIndirectReference());
                pdfIndirectObject.writeTo(this.os);
            }
            object = this.body.add(this.root);
            ((PdfIndirectObject)object).writeTo(this.os);
            pdfIndirectObject = this.body.add(((PdfDocument)this.document).getCatalog(((PdfIndirectObject)object).getIndirectReference()));
            pdfIndirectObject.writeTo(this.os);
            PdfIndirectObject pdfIndirectObject2 = this.body.add(((PdfDocument)this.document).getInfo());
            pdfIndirectObject2.writeTo(this.os);
            this.os.write(this.body.getCrossReferenceTable());
            PdfTrailer pdfTrailer = new PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectObject.getIndirectReference(), pdfIndirectObject2.getIndirectReference());
            this.os.write(pdfTrailer.toPdf());
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    int size() {
        return this.body.size();
    }

    public boolean fitsPage(Table table, float f) {
        return this.pdf.bottom(table) > this.pdf.indentBottom() + f;
    }

    public boolean fitsPage(Table table) {
        return this.fitsPage(table, 0.0f);
    }

    boolean isPaused() {
        return this.pause;
    }

    public PdfContentByte getDirectContent() {
        return this.directContent;
    }

    public PdfContentByte getDirectContentUnder() {
        return this.directContentUnder;
    }

    void resetContent() {
        this.directContent.reset();
        this.directContentUnder.reset();
    }

    PdfName add(BaseFont baseFont) {
        Object[] objectArray = this.addSimple(baseFont);
        this.pdf.addFont((PdfName)objectArray[0], (PdfIndirectReference)objectArray[1]);
        return (PdfName)objectArray[0];
    }

    Object[] addSimple(BaseFont baseFont) {
        Object[] objectArray = (Object[])this.documentFonts.get(baseFont);
        if (objectArray == null) {
            PdfIndirectReference pdfIndirectReference = null;
            try {
                int n = 0;
                while (n < 3) {
                    PdfObject pdfObject = baseFont.getFontInfo(pdfIndirectReference, n);
                    if (pdfObject != null) {
                        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject);
                        pdfIndirectReference = pdfIndirectObject.getIndirectReference();
                        pdfIndirectObject.writeTo(this.os);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
            String string = "F" + this.fontNumber++;
            try {
                objectArray = new Object[]{new PdfName(string), pdfIndirectReference};
            }
            catch (BadPdfFormatException badPdfFormatException) {
                // empty catch block
            }
            this.documentFonts.put(baseFont, objectArray);
        }
        return objectArray;
    }

    PdfDocument getPdfDocument() {
        return this.pdf;
    }

    PdfIndirectReference getPdfIndirectReference() {
        return this.body.getPdfIndirectReference();
    }

    PdfName addDirectTemplateSimple(PdfTemplate pdfTemplate) {
        PdfName pdfName = (PdfName)this.formXObjects.get(pdfTemplate);
        try {
            if (pdfName == null) {
                pdfName = new PdfName("Xf" + this.formXObjectsCounter);
                ++this.formXObjectsCounter;
                this.formXObjects.put(pdfTemplate, pdfName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pdfName;
    }

    public void setPageEvent(PdfPageEvent pdfPageEvent) {
        this.pageEvent = pdfPageEvent;
    }

    public PdfPageEvent getPageEvent() {
        return this.pageEvent;
    }

    void addLocalDestinations(TreeMap treeMap) throws IOException {
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object[] objectArray = (Object[])treeMap.get(string);
            PdfDestination pdfDestination = (PdfDestination)objectArray[2];
            if (pdfDestination == null) {
                throw new RuntimeException("The name '" + string + "' has no local destination.");
            }
            if (objectArray[1] == null) {
                objectArray[1] = this.getPdfIndirectReference();
            }
            PdfIndirectObject pdfIndirectObject = this.body.add(pdfDestination, (PdfIndirectReference)objectArray[1]);
            pdfIndirectObject.writeTo(this.os);
        }
    }

    class PdfTrailer {
        private byte[] bytes;

        public PdfTrailer(int n, int n2, PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(DocWriter.getISOBytes("trailer\n"));
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.SIZE, new PdfNumber(n));
                pdfDictionary.put(PdfName.ROOT, pdfIndirectReference);
                if (pdfIndirectReference2 != null) {
                    pdfDictionary.put(PdfName.INFO, pdfIndirectReference2);
                }
                byteArrayOutputStream.write(pdfDictionary.toPdf());
                byteArrayOutputStream.write(DocWriter.getISOBytes("\nstartxref\n"));
                byteArrayOutputStream.write(DocWriter.getISOBytes(String.valueOf(n2)));
                byteArrayOutputStream.write(DocWriter.getISOBytes("\n%%EOF"));
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error in PdfTrailer!  Error was: " + iOException);
            }
            this.bytes = byteArrayOutputStream.toByteArray();
        }

        final byte[] toPdf() {
            return this.bytes;
        }
    }

    public class PdfBody {
        private int rootOffset;
        private ArrayList xrefs = new ArrayList();
        private int position;

        PdfBody(int n) {
            this.xrefs.add(new PdfCrossReference(0, 65535));
            this.xrefs.add(new PdfCrossReference(0));
            this.position = n;
        }

        final PdfIndirectObject add(PdfObject pdfObject) {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(this.size(), pdfObject);
            this.xrefs.add(new PdfCrossReference(this.position));
            this.position += pdfIndirectObject.length();
            return pdfIndirectObject;
        }

        final PdfIndirectReference getPdfIndirectReference() {
            this.xrefs.add(new PdfCrossReference(0));
            return new PdfIndirectReference(0, this.size() - 1);
        }

        final PdfIndirectObject add(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference) {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(pdfIndirectReference.getNumber(), pdfObject);
            this.xrefs.set(pdfIndirectReference.getNumber(), new PdfCrossReference(this.position));
            this.position += pdfIndirectObject.length();
            return pdfIndirectObject;
        }

        final PdfIndirectObject add(PdfResources pdfResources) {
            return this.add(pdfResources);
        }

        final PdfIndirectObject add(PdfPages pdfPages) {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(1, pdfPages);
            this.rootOffset = this.position;
            this.position += pdfIndirectObject.length();
            return pdfIndirectObject;
        }

        final int offset() {
            return this.position;
        }

        final int size() {
            return this.xrefs.size();
        }

        final byte[] getCrossReferenceTable() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(DocWriter.getISOBytes("xref\n0 "));
                byteArrayOutputStream.write(DocWriter.getISOBytes(String.valueOf(this.size())));
                byteArrayOutputStream.write(DocWriter.getISOBytes("\n"));
                this.xrefs.set(1, new PdfCrossReference(this.rootOffset));
                Iterator iterator = ((AbstractList)this.xrefs).iterator();
                while (iterator.hasNext()) {
                    PdfCrossReference pdfCrossReference = (PdfCrossReference)iterator.next();
                    byteArrayOutputStream.write(pdfCrossReference.toPdf());
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error in PdfIndirectObject::getBytes()!  Error was: " + iOException);
            }
            return byteArrayOutputStream.toByteArray();
        }

        class PdfCrossReference {
            private int offset;
            private int generation;

            PdfCrossReference(int n, int n2) {
                this.offset = n;
                this.generation = n2;
            }

            PdfCrossReference(int n) {
                this(n, 0);
            }

            final byte[] toPdf() {
                String string = "0000000000" + this.offset;
                StringBuffer stringBuffer = new StringBuffer(string.substring(string.length() - 10));
                string = "00000" + this.generation;
                StringBuffer stringBuffer2 = new StringBuffer(string.substring(string.length() - 5));
                if (this.generation == 65535) {
                    return DocWriter.getISOBytes(stringBuffer.append(' ').append((Object)stringBuffer2).append(" f \n").toString());
                }
                return DocWriter.getISOBytes(stringBuffer.append(' ').append((Object)stringBuffer2).append(" n \n").toString());
            }
        }
    }
}

