/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPrintable;
import java.io.UnsupportedEncodingException;

class PdfString
extends PdfObject
implements PdfPrintable {
    protected String value = "";
    protected String encoding = "ISO8859_1";

    PdfString() {
        super(3, "");
    }

    PdfString(String string) {
        super(3, string);
        this.value = string;
    }

    PdfString(String string, BaseFont baseFont) {
        super(3, string);
        this.value = string;
        this.encoding = baseFont.getEncoding();
    }

    PdfString(String string, String string2) {
        super(3, string);
        this.value = string;
        this.encoding = string2;
    }

    PdfString(byte[] byArray) {
        super(3, byArray);
        try {
            this.value = new String(byArray, "ISO8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.value = new String(byArray);
        }
    }

    PdfString(PdfPrintable pdfPrintable) {
        super(3, pdfPrintable.toString());
        this.value = pdfPrintable.toString();
    }

    PdfString(PdfPrintable pdfPrintable, BaseFont baseFont) {
        super(3, pdfPrintable.toString());
        this.value = pdfPrintable.toString();
        this.encoding = baseFont.getEncoding();
    }

    public final byte[] toPdf() {
        byte[] byArray;
        try {
            byArray = this.value.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = this.value.getBytes();
        }
        return PdfContentByte.escapeString(byArray);
    }

    public String toString() {
        return this.value;
    }

    byte[] get() {
        return this.toPdf();
    }

    boolean isCJKEncoding() {
        return this.encoding.equals("UnicodeBigUnmarked");
    }

    String getEncoding() {
        return this.encoding;
    }
}

