/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import java.awt.Color;

public class PdfPRow {
    protected PdfContentByte lines;
    protected PdfContentByte backgr;
    protected PdfContentByte text;
    protected PdfPCell[] cells;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;

    public PdfPRow(PdfContentByte pdfContentByte, PdfContentByte pdfContentByte2, PdfContentByte pdfContentByte3, PdfPCell[] pdfPCellArray) {
        this.lines = pdfContentByte;
        this.backgr = pdfContentByte2;
        this.text = pdfContentByte3;
        this.cells = pdfPCellArray;
    }

    public float calculateHeights() {
        int n = 0;
        while (n < this.cells.length) {
            PdfPCell pdfPCell = this.cells[n];
            float f = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.right() - pdfPCell.getPaddingRight();
            ColumnText columnText = new ColumnText(this.text);
            columnText.setSimpleColumn(pdfPCell.getPhrase(), pdfPCell.left() + pdfPCell.getPaddingLeft(), pdfPCell.top() - pdfPCell.getPaddingTop(), f, -20000.0f, 0.0f, pdfPCell.getHorizontalAlignment());
            columnText.setLeading(pdfPCell.getLeading(), pdfPCell.getMultipliedLeading());
            columnText.setIndent(pdfPCell.getIndent());
            columnText.setExtraParagraphSpace(pdfPCell.getExtraParagraphSpace());
            try {
                columnText.go(true);
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
            float f2 = columnText.getYLine();
            pdfPCell.setBottom(f2 - pdfPCell.getPaddingBottom());
            float f3 = pdfPCell.height();
            if (f3 < pdfPCell.getFixedHeight()) {
                f3 = pdfPCell.getFixedHeight();
            }
            if (f3 > this.maxHeight) {
                this.maxHeight = f3;
            }
            ++n;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeCells() {
        if (!this.calculated) {
            this.calculateHeights();
        }
        int n = 0;
        while (n < this.cells.length) {
            PdfPCell pdfPCell = this.cells[n];
            float f = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.right() - pdfPCell.getPaddingRight();
            ColumnText columnText = new ColumnText(this.text);
            float f2 = 0.0f;
            switch (pdfPCell.getVerticalAlignment()) {
                case 6: {
                    f2 = pdfPCell.top() - this.maxHeight + pdfPCell.height() - pdfPCell.getPaddingTop();
                    break;
                }
                case 5: {
                    f2 = pdfPCell.top() + (pdfPCell.height() - this.maxHeight) / 2.0f - pdfPCell.getPaddingTop();
                    break;
                }
                default: {
                    f2 = pdfPCell.top() - pdfPCell.getPaddingTop();
                }
            }
            columnText.setSimpleColumn(pdfPCell.getPhrase(), pdfPCell.left() + pdfPCell.getPaddingLeft(), f2, f, -20000.0f, 0.0f, pdfPCell.getHorizontalAlignment());
            columnText.setLeading(pdfPCell.getLeading(), pdfPCell.getMultipliedLeading());
            columnText.setIndent(pdfPCell.getIndent());
            columnText.setExtraParagraphSpace(pdfPCell.getExtraParagraphSpace());
            try {
                columnText.go();
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
            float f3 = pdfPCell.left();
            float f4 = pdfPCell.top();
            float f5 = pdfPCell.right();
            float f6 = f4 - this.maxHeight;
            Color color = pdfPCell.backgroundColor();
            if (color != null) {
                this.backgr.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
                this.backgr.rectangle(f3, f4, f5 - f3, f6 - f4);
                this.backgr.fill();
            } else if (pdfPCell.grayFill() > 0.0f) {
                this.backgr.setGrayFill(pdfPCell.grayFill());
                this.backgr.rectangle(f3, f4, f5 - f3, f6 - f4);
                this.backgr.fill();
            }
            if (pdfPCell.hasBorders()) {
                Color color2;
                if (pdfPCell.borderWidth() != -1.0f) {
                    this.lines.setLineWidth(pdfPCell.borderWidth());
                }
                if ((color2 = pdfPCell.borderColor()) != null) {
                    this.lines.setRGBColorStroke(color2.getRed(), color2.getGreen(), color2.getBlue());
                }
                if (pdfPCell.hasBorder(15)) {
                    this.lines.rectangle(f3, f4, f5 - f3, f6 - f4);
                } else {
                    if (pdfPCell.hasBorder(8)) {
                        this.lines.moveTo(f5, f4);
                        this.lines.lineTo(f5, f6);
                    }
                    if (pdfPCell.hasBorder(4)) {
                        this.lines.moveTo(f3, f4);
                        this.lines.lineTo(f3, f6);
                    }
                    if (pdfPCell.hasBorder(2)) {
                        this.lines.moveTo(f3, f6);
                        this.lines.lineTo(f5, f6);
                    }
                    if (pdfPCell.hasBorder(1)) {
                        this.lines.moveTo(f3, f4);
                        this.lines.lineTo(f5, f4);
                    }
                }
                this.lines.stroke();
                if (color2 != null) {
                    this.lines.resetRGBColorStroke();
                }
            }
            ++n;
        }
    }
}

