/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import java.util.AbstractList;
import java.util.Iterator;

public class PdfOutline
extends PdfDictionary {
    private PdfIndirectReference reference;
    private int count = 0;
    private PdfOutline parent;
    private PdfDestination destination;
    private boolean isOpen;

    PdfOutline() {
        super(PdfDictionary.OUTLINES);
        this.isOpen = true;
        this.parent = null;
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, PdfString pdfString) {
        this(pdfOutline, pdfDestination, pdfString, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, String string) {
        this(pdfOutline, pdfDestination, string, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, Paragraph paragraph) {
        this(pdfOutline, pdfDestination, paragraph, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, PdfString pdfString, boolean bl) {
        this(pdfOutline, pdfDestination, pdfString.toString(), true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, String string, boolean bl) {
        boolean bl2 = this.isOpen = bl && pdfOutline.isOpen;
        if (this.isOpen || pdfOutline.isOpen) {
            pdfOutline.add();
        }
        this.parent = pdfOutline;
        this.destination = pdfDestination;
        this.put(PdfName.TITLE, new PdfString(string, "UnicodeBig"));
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, Paragraph paragraph, boolean bl) {
        boolean bl2 = this.isOpen = bl && pdfOutline.isOpen;
        if (this.isOpen || pdfOutline.isOpen) {
            pdfOutline.add();
        }
        this.parent = pdfOutline;
        this.destination = pdfDestination;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)paragraph.getChunks()).iterator();
        while (iterator.hasNext()) {
            Chunk chunk = (Chunk)iterator.next();
            stringBuffer.append(chunk.content());
        }
        this.put(PdfName.TITLE, new PdfString(stringBuffer.toString(), "UnicodeBig"));
    }

    public void setIndirectReference(PdfIndirectReference pdfIndirectReference) {
        this.reference = pdfIndirectReference;
    }

    public PdfIndirectReference indirectReference() {
        return this.reference;
    }

    public PdfOutline parent() {
        return this.parent;
    }

    public boolean setDestinationPage(PdfIndirectReference pdfIndirectReference) {
        if (this.destination == null) {
            return false;
        }
        return this.destination.addPage(pdfIndirectReference);
    }

    public PdfDestination getPdfDestination() {
        return this.destination;
    }

    public void add() {
        if (this.parent != null) {
            this.parent.add();
        }
        ++this.count;
    }

    public int level() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.level() + 1;
    }

    public final byte[] toPdf() {
        if (this.parent != null) {
            this.put(PdfName.PARENT, this.parent.indirectReference());
        }
        if (this.destination != null && this.destination.hasPage()) {
            this.put(PdfName.DEST, this.destination);
        }
        if ((this.isOpen || this.parent.isOpen) && this.count > 0) {
            this.put(PdfName.COUNT, new PdfNumber(this.count));
        }
        return super.toPdf();
    }
}

