/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import java.io.UnsupportedEncodingException;

abstract class PdfObject {
    static final int NULL = 0;
    static final int BOOLEAN = 1;
    static final int NUMBER = 2;
    static final int STRING = 3;
    static final int NAME = 4;
    static final int ARRAY = 5;
    static final int DICTIONARY = 6;
    static final int STREAM = 7;
    public static final String NOTHING = "";
    public static final String ENCODING = "ISO8859_1";
    protected byte[] bytes = new byte[0];
    protected int type;

    protected PdfObject(int n) {
        this.type = n;
    }

    protected PdfObject(int n, String string) {
        try {
            this.bytes = string.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.bytes = string.getBytes();
        }
        this.type = n;
    }

    protected PdfObject(int n, byte[] byArray) {
        this.bytes = byArray;
        this.type = n;
    }

    public byte[] toPdf() {
        return this.bytes;
    }

    final int pdfLength() {
        return this.toPdf().length;
    }

    public String toString() {
        try {
            return new String(this.toPdf(), ENCODING);
        }
        catch (Exception exception) {
            return new String(this.toPdf());
        }
    }

    public int length() {
        return this.toString().length();
    }

    protected void setContent(String string) {
        try {
            this.bytes = string.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.bytes = string.getBytes();
        }
    }

    final int type() {
        return this.type;
    }

    public final boolean isNull() {
        return this.type == 0;
    }

    public final boolean isBoolean() {
        return this.type == 1;
    }

    public final boolean isNumber() {
        return this.type == 2;
    }

    public final boolean isString() {
        return this.type == 3;
    }

    final boolean isName() {
        return this.type == 4;
    }

    final boolean isArray() {
        return this.type == 5;
    }

    final boolean isDictionary() {
        return this.type == 6;
    }

    final boolean isStream() {
        return this.type == 7;
    }
}

