/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfObject;

public abstract class PdfFontMetrics {
    public static final int COURIER = 0;
    public static final int COURIER_BOLD = 1;
    public static final int COURIER_OBLIQUE = 2;
    public static final int COURIER_BOLDOBLIQUE = 3;
    public static final int HELVETICA = 4;
    public static final int HELVETICA_BOLD = 5;
    public static final int HELVETICA_OBLIQUE = 6;
    public static final int HELVETICA_BOLDOBLIQUE = 7;
    public static final int SYMBOL = 8;
    public static final int TIMES_ROMAN = 9;
    public static final int TIMES_BOLD = 10;
    public static final int TIMES_ITALIC = 11;
    public static final int TIMES_BOLDITALIC = 12;
    public static final int ZAPFDINGBATS = 13;
    public static final float SIZE_8 = 8.0f;
    public static final float SIZE_10 = 10.0f;
    public static final float SIZE_12 = 12.0f;
    public static final float SIZE_14 = 14.0f;
    public static final float SIZE_18 = 18.0f;
    public static final float SIZE_24 = 24.0f;
    public static final int STANDARD = 0;
    public static final int MAC_ROMAN = 1;
    public static final int MAC_EXPERT = 2;
    public static final int WIN_ANSI = 3;
    private static PdfObject[] encodings = new PdfObject[4];
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLDITALIC = 3;
    public static final char SPACE = ' ';
    public static final char ZERO = '0';
    public static final char ELLIPSIS_STANDARD = '\u00bc';
    public static final char ELLIPSIS_MAC_ROMAN = '\u00c9';
    public static final char ELLIPSIS_WIN_ANSI = '\u0085';
    private int encoding;
    private float size;
    private int[] width;
    private int[][] kerning = null;

    protected PdfFontMetrics(int n, float f) {
        this.encoding = PdfFontMetrics.checkEncoding(n);
        this.size = PdfFontMetrics.checkFontsize(f);
    }

    protected final void setWidth(int[] nArray) {
        this.width = nArray;
    }

    protected final void setKerning(int[][] nArray) {
        this.kerning = nArray;
    }

    public abstract PdfName name();

    final PdfObject encoding() {
        return encodings[this.encoding];
    }

    final float size() {
        return this.size;
    }

    private final int width(char c) {
        return this.width[c & 0xFF];
    }

    final double widthTextSpace(char c) {
        return 0.001 * ((double)this.width(c) * (double)this.size);
    }

    final double widthTextSpace() {
        return this.widthTextSpace(' ');
    }

    public int kerning(char c, char c2) {
        if (this.kerning == null) {
            return 0;
        }
        int n = c & 0xFF;
        int n2 = c2 & 0xFF;
        int[] nArray = this.kerning[n];
        if (nArray == null) {
            return 0;
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] == n2) {
                return nArray[n3 + 1];
            }
            if (nArray[n3] > n2) {
                return 0;
            }
            n3 += 2;
        }
        return 0;
    }

    public abstract int getStyle(int var1);

    char ellipsis() {
        switch (this.encoding) {
            case 1: {
                return '\u00c9';
            }
            case 3: {
                return '\u0085';
            }
        }
        return '\u00bc';
    }

    static boolean isSplitCharacter(char c) {
        if (c <= ' ') {
            return true;
        }
        switch (c) {
            case '\t': 
            case ' ': 
            case '-': {
                return true;
            }
        }
        return false;
    }

    static String trim(String string) {
        while (string.endsWith(" ") || string.endsWith("\t")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    static final int checkFonttype(int n) {
        if (n < 0 || n > 13) {
            return 0;
        }
        return n;
    }

    static final float checkFontsize(float f) {
        if (f < 0.0f || f > 1000.0f) {
            return 12.0f;
        }
        return f;
    }

    static final int checkEncoding(int n) {
        if (n < 0 || n > 3) {
            return 3;
        }
        return n;
    }

    static final PdfObject getEncoding(int n) {
        return encodings[PdfFontMetrics.checkEncoding(n)];
    }

    static {
        PdfFontMetrics.encodings[0] = PdfNull.PDFNULL;
        PdfFontMetrics.encodings[1] = PdfName.MAC_ROMAN_ENCODING;
        PdfFontMetrics.encodings[2] = PdfName.MAC_EXPERT_ENCODING;
        PdfFontMetrics.encodings[3] = PdfName.WIN_ANSI_ENCODING;
    }
}

