/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfNumber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class PdfDashPattern
extends PdfArray {
    private float dash = -1.0f;
    private float gap = -1.0f;
    private float phase;

    PdfDashPattern() {
    }

    PdfDashPattern(float f) {
        super(new PdfNumber(f));
        this.dash = f;
    }

    PdfDashPattern(float f, float f2) {
        super(new PdfNumber(f));
        this.add(new PdfNumber(f2));
        this.dash = f;
        this.gap = f2;
    }

    PdfDashPattern(float f, float f2, float f3) {
        super(new PdfNumber(f));
        this.add(new PdfNumber(f2));
        this.dash = f;
        this.gap = f2;
        this.phase = f3;
    }

    public final byte[] toPdf() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(DocWriter.getISOBytes("["));
            if (this.dash >= 0.0f) {
                byteArrayOutputStream.write(new PdfNumber(this.dash).toPdf());
                if (this.gap >= 0.0f) {
                    byteArrayOutputStream.write(DocWriter.getISOBytes(" "));
                    byteArrayOutputStream.write(new PdfNumber(this.gap).toPdf());
                }
            }
            byteArrayOutputStream.write(DocWriter.getISOBytes("]"));
            if (this.phase >= 0.0f) {
                byteArrayOutputStream.write(DocWriter.getISOBytes(" "));
                byteArrayOutputStream.write(new PdfNumber(this.phase).toPdf());
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }
}

