/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.TrueTypeFont;
import com.lowagie.text.pdf.Type1Font;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public abstract class BaseFont {
    public static final String notdef = new String(".notdef");
    protected int[] widths = new int[256];
    protected String[] differences = new String[256];
    protected String encoding;
    protected boolean embedded;
    protected boolean fontSpecific = true;
    protected static HashMap fontCache = new HashMap();
    protected static final HashMap BuiltinFonts14 = new HashMap();

    protected BaseFont() {
    }

    public static BaseFont createFont(String string, String string2, boolean bl) throws DocumentException, IOException {
        boolean bl2;
        String string3 = BaseFont.getBaseName(string);
        string2 = BaseFont.normalizeEncoding(string2);
        boolean bl3 = BuiltinFonts14.containsKey(string);
        boolean bl4 = bl2 = bl3 ? false : CJKFont.isCJKFont(string3, string2);
        if (bl3 || bl2) {
            bl = false;
        }
        BaseFont baseFont = null;
        BaseFont baseFont2 = null;
        String string4 = string + "\n" + string2 + "\n" + bl;
        HashMap hashMap = fontCache;
        synchronized (hashMap) {
            baseFont = (BaseFont)fontCache.get(string4);
        }
        if (baseFont != null) {
            return baseFont;
        }
        if (bl3 || string.toLowerCase().endsWith(".afm")) {
            baseFont2 = new Type1Font(string, string2, bl);
        } else if (string3.toLowerCase().endsWith(".ttf")) {
            baseFont2 = new TrueTypeFont(string, string2, bl);
        } else if (bl2) {
            baseFont2 = new CJKFont(string, string2, bl);
        } else {
            throw new DocumentException("Font '" + string + "' with '" + string2 + "' is not recognized.");
        }
        HashMap hashMap2 = fontCache;
        synchronized (hashMap2) {
            baseFont = (BaseFont)fontCache.get(string4);
            if (baseFont != null) {
                BaseFont baseFont3 = baseFont;
                return baseFont3;
            }
            fontCache.put(string4, baseFont2);
        }
        return baseFont2;
    }

    protected static String getBaseName(String string) {
        if (string.endsWith(",Bold")) {
            return string.substring(0, string.length() - 5);
        }
        if (string.endsWith(",Italic")) {
            return string.substring(0, string.length() - 7);
        }
        if (string.endsWith(",BoldItalic")) {
            return string.substring(0, string.length() - 11);
        }
        return string;
    }

    protected static String normalizeEncoding(String string) {
        if (string.equals("winansi") || string.equals("")) {
            return "Cp1252";
        }
        if (string.equals("macroman")) {
            return "MacRoman";
        }
        return string;
    }

    protected void createEncoding() throws UnsupportedEncodingException {
        byte[] byArray = new byte[256];
        int n = 0;
        while (n < 256) {
            byArray[n] = (byte)n;
            ++n;
        }
        if (this.fontSpecific) {
            int n2 = 0;
            while (n2 < 256) {
                this.widths[n2] = this.getRawWidth(n2, null);
                ++n2;
            }
        } else {
            String string = new String(byArray, this.encoding);
            int n3 = 0;
            while (n3 < 256) {
                char c = string.charAt(n3);
                String string2 = GlyphList.unicodeToName(c);
                if (string2 == null) {
                    string2 = notdef;
                }
                this.differences[n3] = string2;
                this.widths[n3] = this.getRawWidth(c, string2);
                ++n3;
            }
        }
    }

    protected abstract int getRawWidth(int var1, String var2);

    public abstract int getKerning(char var1, char var2);

    public int getWidth(char c) {
        return this.getWidth(new String(new char[]{c}));
    }

    public int getWidth(String string) {
        int n = 0;
        try {
            byte[] byArray = string.getBytes(this.encoding);
            int n2 = 0;
            while (n2 < byArray.length) {
                n += this.widths[0xFF & byArray[n2]];
                ++n2;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return n;
    }

    public float getWidthPoint(String string, float f) {
        return (float)this.getWidth(string) * 0.001f * f;
    }

    public float getWidthPoint(char c, float f) {
        return (float)this.getWidth(c) * 0.001f * f;
    }

    public static boolean isSplitCharacter(char c) {
        if (c <= ' ') {
            return true;
        }
        switch (c) {
            case '\t': 
            case ' ': 
            case '-': {
                return true;
            }
        }
        return false;
    }

    byte[] convertToBytes(String string) {
        try {
            return string.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    abstract PdfObject getFontInfo(PdfIndirectReference var1, int var2) throws DocumentException;

    public String getEncoding() {
        return this.encoding;
    }

    static {
        BuiltinFonts14.put("Courier", PdfName.COURIER);
        BuiltinFonts14.put("Courier-Bold", PdfName.COURIER_BOLD);
        BuiltinFonts14.put("Courier-BoldOblique", PdfName.COURIER_BOLDOBLIQUE);
        BuiltinFonts14.put("Courier-Oblique", PdfName.COURIER_OBLIQUE);
        BuiltinFonts14.put("Helvetica", PdfName.HELVETICA);
        BuiltinFonts14.put("Helvetica-Bold", PdfName.HELVETICA_BOLD);
        BuiltinFonts14.put("Helvetica-BoldOblique", PdfName.HELVETICA_BOLDOBLIQUE);
        BuiltinFonts14.put("Helvetica-Oblique", PdfName.HELVETICA_OBLIQUE);
        BuiltinFonts14.put("Symbol", PdfName.SYMBOL);
        BuiltinFonts14.put("Times-Roman", PdfName.TIMES_ROMAN);
        BuiltinFonts14.put("Times-Bold", PdfName.TIMES_BOLD);
        BuiltinFonts14.put("Times-BoldItalic", PdfName.TIMES_BOLDITALIC);
        BuiltinFonts14.put("Times-Italic", PdfName.TIMES_ITALIC);
        BuiltinFonts14.put("ZapfDingbats", PdfName.ZAPFDINGBATS);
    }

    class StreamFont
    extends PdfStream {
        public StreamFont(byte[] byArray, int[] nArray) throws DocumentException {
            try {
                this.bytes = byArray;
                this.dictionary.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                int n = 0;
                while (n < nArray.length) {
                    this.dictionary.put(new PdfName("Length" + (n + 1)), new PdfNumber(nArray[n]));
                    ++n;
                }
                this.flateCompress();
            }
            catch (Exception exception) {
                throw new DocumentException(exception.getMessage());
            }
        }
    }
}

