/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import java.awt.Color;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class Table
extends Rectangle
implements Element {
    private int columns;
    private int currentRow;
    private ArrayList rows = new ArrayList();
    private Cell defaultLayout = new Cell();
    private int lastHeaderRow = -1;
    private int alignment = 1;
    private float cellpadding;
    private float cellspacing;
    private float widthPercentage = 80.0f;
    private String absWidth = "";
    private float[] widths;

    public Table(int n) throws BadElementException {
        this(n, 1);
    }

    public Table(int n, int n2) throws BadElementException {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(15);
        this.setBorderWidth(1.0f);
        if (n <= 0) {
            throw new BadElementException("A table should have at least 1 column.");
        }
        this.columns = n;
        int n3 = 0;
        while (n3 < n2) {
            this.rows.add(new Row(n));
            ++n3;
        }
        this.currentRow = 0;
        this.widths = new float[n];
        float f = 100.0f / (float)n;
        int n4 = 0;
        while (n4 < n) {
            this.widths[n4] = f;
            ++n4;
        }
    }

    public final boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public final int type() {
        return 22;
    }

    public final ArrayList getChunks() {
        return new ArrayList();
    }

    public final void addCell(Cell cell) {
        int n;
        Row row = (Row)this.rows.get(this.currentRow);
        while ((n = row.addCell(cell)) < 0) {
            ++this.currentRow;
            if (this.currentRow >= this.rows.size()) {
                row = new Row(row.columns());
                this.rows.add(row);
            }
            row = (Row)this.rows.get(this.currentRow);
        }
        int n2 = 1;
        while (n2 < cell.colspan()) {
            row.reserve(n + n2);
            ++n2;
        }
        int n3 = 1;
        while (n3 < cell.rowspan()) {
            int n4 = 0;
            while (n4 < cell.colspan()) {
                if (this.currentRow + n3 >= this.rows.size()) {
                    this.rows.add(new Row(row.columns()));
                }
                row = (Row)this.rows.get(this.currentRow + n3);
                row.reserve(n + n4);
                ++n4;
            }
            ++n3;
        }
    }

    public final void addCell(Phrase phrase) throws BadElementException {
        Cell cell = new Cell(phrase);
        cell.setBorder(this.defaultLayout.border());
        cell.setBorderWidth(this.defaultLayout.borderWidth());
        cell.setBorderColor(this.defaultLayout.borderColor());
        cell.setBackgroundColor(this.defaultLayout.backgroundColor());
        cell.setGrayFill(this.defaultLayout.grayFill());
        cell.setHorizontalAlignment(this.defaultLayout.horizontalAlignment());
        cell.setVerticalAlignment(this.defaultLayout.verticalAlignment());
        cell.setColspan(this.defaultLayout.colspan());
        cell.setRowspan(this.defaultLayout.rowspan());
        this.addCell(cell);
    }

    public final void addCell(String string) throws BadElementException {
        this.addCell(new Paragraph(string));
    }

    public final void setDefaultCellBorder(int n) {
        this.defaultLayout.setBorder(n);
    }

    public final void setDefaultCellBorderWidth(float f) {
        this.defaultLayout.setBorderWidth(f);
    }

    public final void setDefaultCellBorderColor(Color color) {
        this.defaultLayout.setBorderColor(color);
    }

    public final void setDefaultCellBackgroundColor(Color color) {
        this.defaultLayout.setBackgroundColor(color);
    }

    public final void setDefaultCellGrayFill(float f) {
        if (f >= 0.0f && f <= 1.0f) {
            this.defaultLayout.setGrayFill(f);
        }
    }

    public final void setDefaultHorizontalAlignment(int n) {
        this.defaultLayout.setHorizontalAlignment(n);
    }

    public final void setDefaultVerticalAlignment(int n) {
        this.defaultLayout.setVerticalAlignment(n);
    }

    public final void setDefaultRowspan(int n) {
        this.defaultLayout.setRowspan(n);
    }

    public final void setDefaultColspan(int n) {
        this.defaultLayout.setColspan(n);
    }

    public final void deleteColumn(int n) throws DocumentException {
        float[] fArray = new float[--this.columns];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = this.widths[n2];
            ++n2;
        }
        int n3 = n;
        while (n3 < this.columns) {
            fArray[n3] = this.widths[n3 + 1];
            ++n3;
        }
        this.setWidths(fArray);
        int n4 = 0;
        while (n4 < this.columns) {
            fArray[n4] = this.widths[n4];
            ++n4;
        }
        this.widths = fArray;
        int n5 = this.rows.size();
        int n6 = 0;
        while (n6 < n5) {
            Row row = (Row)this.rows.get(n6);
            row.deleteColumn(n);
            this.rows.set(n6, row);
            ++n6;
        }
    }

    public final boolean deleteRow(int n) {
        if (n < 0 || n >= this.rows.size()) {
            return false;
        }
        this.rows.remove(n);
        return true;
    }

    public final boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public int endHeaders() {
        this.lastHeaderRow = this.currentRow;
        return this.lastHeaderRow;
    }

    public final void setAlignment(int n) {
        this.alignment = n;
    }

    public final void setCellpadding(float f) {
        this.cellpadding = f;
    }

    public final void setCellspacing(float f) {
        this.cellspacing = f;
    }

    public final void setWidth(float f) {
        this.widthPercentage = f;
    }

    public final void setAbsWidth(String string) {
        this.absWidth = string;
    }

    public final void setWidths(float[] fArray) throws DocumentException {
        if (fArray.length != this.columns) {
            throw new DocumentException("Wrong number of columns.");
        }
        float f = 0.0f;
        int n = 0;
        while (n < this.columns) {
            f += fArray[n];
            ++n;
        }
        this.widths[this.columns - 1] = 100.0f;
        int n2 = 0;
        while (n2 < this.columns - 1) {
            float f2;
            this.widths[n2] = f2 = 100.0f * fArray[n2] / f;
            int n3 = this.columns - 1;
            this.widths[n3] = this.widths[n3] - f2;
            ++n2;
        }
    }

    public final void setWidths(int[] nArray) throws DocumentException {
        float[] fArray = new float[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            fArray[n] = nArray[n];
            ++n;
        }
        this.setWidths(fArray);
    }

    public final int size() {
        return this.rows.size();
    }

    public Iterator iterator() {
        return ((AbstractList)this.rows).iterator();
    }

    public int alignment() {
        return this.alignment;
    }

    public float cellpadding() {
        return this.cellpadding;
    }

    public float cellspacing() {
        return this.cellspacing;
    }

    public float widthPercentage() {
        return this.widthPercentage;
    }

    public String absWidth() {
        return this.absWidth;
    }

    public int firstDataRow() {
        return this.lastHeaderRow + 1;
    }

    public float[] getWidths(float f, float f2) {
        float[] fArray = new float[this.columns + 1];
        switch (this.alignment) {
            case 0: {
                fArray[0] = f;
                break;
            }
            case 2: {
                fArray[0] = f + f2 * (100.0f - this.widthPercentage) / 100.0f;
                break;
            }
            default: {
                fArray[0] = f + f2 * (100.0f - this.widthPercentage) / 200.0f;
            }
        }
        f2 = f2 * this.widthPercentage / 100.0f;
        int n = 1;
        while (n < this.columns) {
            fArray[n] = fArray[n - 1] + this.widths[n - 1] * f2 / 100.0f;
            ++n;
        }
        fArray[this.columns] = fArray[0] + f2;
        return fArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<TABLE WIDTH=\"");
        if (!this.absWidth.equals("")) {
            stringBuffer.append(this.absWidth);
        } else {
            stringBuffer.append(this.widthPercentage);
        }
        stringBuffer.append("%\" HORIZONTAL_ALIGNMENT=\"");
        switch (this.alignment) {
            case 0: {
                stringBuffer.append("Left");
                break;
            }
            case 1: {
                stringBuffer.append("Center");
                break;
            }
            case 2: {
                stringBuffer.append("Right");
                break;
            }
            case 3: {
                stringBuffer.append("Justify");
                break;
            }
            default: {
                stringBuffer.append("Default");
            }
        }
        stringBuffer.append("\" CELLPADDING=\"");
        stringBuffer.append(this.cellpadding);
        stringBuffer.append("\" CELLSPACING=\"");
        stringBuffer.append(this.cellspacing);
        stringBuffer.append("\">\n");
        stringBuffer.append("\t<WIDTHS>\n");
        int n = 0;
        while (n < this.widths.length) {
            stringBuffer.append("\t\t<WITDH COLUMN=\"");
            stringBuffer.append(n);
            stringBuffer.append("\">");
            stringBuffer.append(this.widths[n]);
            stringBuffer.append("</WIDTH>\n");
            ++n;
        }
        stringBuffer.append("\t</WIDTHS>\n");
        if (this.borderWidth > 0.0f) {
            stringBuffer.append("\t<BORDER WIDTH=\"");
            stringBuffer.append(this.borderWidth);
            stringBuffer.append("\">");
            if (this.hasBorder(1)) {
                stringBuffer.append("\t\t<SIDE>");
                stringBuffer.append("top");
                stringBuffer.append("</SIDE>\n");
            }
            if (this.hasBorder(2)) {
                stringBuffer.append("\t\t<SIDE>");
                stringBuffer.append("bottom");
                stringBuffer.append("</SIDE>\n");
            }
            if (this.hasBorder(4)) {
                stringBuffer.append("\t\t<SIDE>");
                stringBuffer.append("left");
                stringBuffer.append("</SIDE>\n");
            }
            if (this.hasBorder(8)) {
                stringBuffer.append("\t\t<SIDE>");
                stringBuffer.append("right");
                stringBuffer.append("</SIDE>\n");
            }
            if (this.color != null) {
                stringBuffer.append("\t\t<COLOR>\n");
                stringBuffer.append("\t\t\t<RED>");
                stringBuffer.append(this.color.getRed());
                stringBuffer.append("</RED>\n");
                stringBuffer.append("\t\t\t<GREEN>");
                stringBuffer.append(this.color.getGreen());
                stringBuffer.append("</GREEN>\n");
                stringBuffer.append("\t\t\t<BLUE>");
                stringBuffer.append(this.color.getBlue());
                stringBuffer.append("</BLUE>\n");
                stringBuffer.append("\t\t</COLOR>\n");
            }
            stringBuffer.append("\t</BORDER>\n");
        }
        Iterator iterator = ((AbstractList)this.rows).iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            stringBuffer.append(row.toString());
        }
        stringBuffer.append("</TABLE>\n");
        return stringBuffer.toString();
    }
}

