/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.Phrase;
import com.lowagie.text.TextElementArray;
import java.util.AbstractList;
import java.util.Iterator;

public class Paragraph
extends Phrase
implements TextElementArray {
    protected int alignment;
    protected float indentationLeft;
    protected float indentationRight;

    public Paragraph() {
    }

    public Paragraph(float f) {
        super(f);
    }

    public Paragraph(Chunk chunk) {
        super(chunk);
    }

    public Paragraph(float f, Chunk chunk) {
        super(f, chunk);
    }

    public Paragraph(String string) {
        super(string);
    }

    public Paragraph(String string, Font font) {
        super(string, font);
    }

    public Paragraph(float f, String string) {
        super(f, string);
    }

    public Paragraph(float f, String string, Font font) {
        super(f, string, font);
    }

    public Paragraph(Phrase phrase) {
        super(phrase.leading());
        this.add(phrase);
    }

    public int type() {
        return 12;
    }

    public boolean add(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            list.setIndentationLeft(list.indentationLeft() + this.indentationLeft);
            list.setIndentationRight(this.indentationRight);
            super.add(list);
        } else if (object instanceof Image) {
            super.addSpecial((Image)object);
        }
        return super.add(object);
    }

    public final void setAlignment(int n) {
        this.alignment = n;
    }

    public final void setAlignment(String string) {
        if ("center".equals(string)) {
            this.alignment = 1;
            return;
        }
        if ("right".equals(string)) {
            this.alignment = 2;
            return;
        }
        if ("justify".equals(string)) {
            this.alignment = 3;
            return;
        }
        this.alignment = 0;
    }

    public final void setIndentationLeft(float f) {
        this.indentationLeft = f;
    }

    public final void setIndentationRight(float f) {
        this.indentationRight = f;
    }

    public final int alignment() {
        return this.alignment;
    }

    public final float indentationLeft() {
        return this.indentationLeft;
    }

    public final float indentationRight() {
        return this.indentationRight;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<paragraph leading=\"");
        stringBuffer.append(this.leading);
        stringBuffer.append("\" align=\"");
        switch (this.alignment) {
            case 0: {
                stringBuffer.append("left");
                break;
            }
            case 1: {
                stringBuffer.append("center");
                break;
            }
            case 2: {
                stringBuffer.append("right");
                break;
            }
            case 3: {
                stringBuffer.append("justify");
                break;
            }
            default: {
                stringBuffer.append("default");
            }
        }
        if (this.indentationLeft != 0.0f) {
            stringBuffer.append("\" left=\"");
            stringBuffer.append(this.indentationLeft);
        }
        if (this.indentationRight != 0.0f) {
            stringBuffer.append("\" right=\"");
            stringBuffer.append(this.indentationRight);
        }
        stringBuffer.append("\">\n");
        Iterator iterator = ((AbstractList)this).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append("\n</paragraph>\n");
        return stringBuffer.toString();
    }
}

