/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;

public class Font
implements Comparable {
    public static final int COURIER = 0;
    public static final int HELVETICA = 1;
    public static final int TIMES_NEW_ROMAN = 2;
    public static final int SYMBOL = 3;
    public static final int ZAPFDINGBATS = 4;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int STRIKETHRU = 8;
    public static final int BOLDITALIC = 3;
    public static final int UNDEFINED = -1;
    public static final int DEFAULTSIZE = 12;
    private int family = -1;
    private float size = -1.0f;
    private int style = -1;
    private Color color = null;
    private BaseFont baseFont = null;

    public Font(int n, float f, int n2, Color color) {
        this.family = n;
        this.size = f;
        this.style = n2;
        this.color = color;
    }

    public Font(BaseFont baseFont, float f, int n, Color color) {
        this.family = this.family;
        this.size = f;
        this.style = n;
        this.color = color;
        this.baseFont = baseFont;
    }

    public Font(BaseFont baseFont, float f, int n) {
        this(baseFont, f, n, null);
    }

    public Font(BaseFont baseFont, float f) {
        this(baseFont, f, -1, null);
    }

    public Font(BaseFont baseFont) {
        this(baseFont, -1.0f, -1, null);
    }

    public Font(int n, float f, int n2) {
        this(n, f, n2, null);
    }

    public Font(int n, float f) {
        this(n, f, -1, null);
    }

    public Font(int n) {
        this(n, -1.0f, -1, null);
    }

    public Font() {
        this(-1, -1.0f, -1, null);
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        try {
            Font font = (Font)object;
            if (this.family != font.family()) {
                return 1;
            }
            if (this.size != font.size()) {
                return 2;
            }
            if (this.style != font.style()) {
                return 3;
            }
            if (this.color == null) {
                if (font.color == null) {
                    return 0;
                }
                return 4;
            }
            if (font.color == null) {
                return 4;
            }
            if (this.color.equals(font.color())) {
                return 0;
            }
            return 4;
        }
        catch (ClassCastException classCastException) {
            return -2;
        }
    }

    public void setFamily(String string) {
        this.family = Font.getFamilyIndex(string);
    }

    public static int getFamilyIndex(String string) {
        if (string.equalsIgnoreCase("Courier")) {
            return 0;
        }
        if (string.equalsIgnoreCase("Helvetica")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Times New Roman")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Symbol")) {
            return 3;
        }
        if (string.equalsIgnoreCase("ZapfDingBats")) {
            return 4;
        }
        return -1;
    }

    public void setSize(float f) {
        this.size = f;
    }

    public void setStyle(String string) {
        this.style = Font.getStyleValue(string);
    }

    public static int getStyleValue(String string) {
        int n = 0;
        if (string.indexOf("normal") != -1) {
            n |= 0;
        }
        if (string.indexOf("bold") != -1) {
            n |= 1;
        }
        if (string.indexOf("italic") != -1) {
            n |= 2;
        }
        if (string.indexOf("underline") != -1) {
            n |= 4;
        }
        if (string.indexOf("strike") != -1) {
            n |= 8;
        }
        return n;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(int n, int n2, int n3) {
        this.color = new Color(n, n2, n3);
    }

    public float leading(float f) {
        if (this.size == -1.0f) {
            return f * 12.0f;
        }
        return f * this.size;
    }

    public boolean isStandardFont() {
        return this.family == -1 && this.size == -1.0f && this.color == null && this.baseFont == null;
    }

    public Font difference(Font font) {
        Font font2 = new Font();
        if (this.family != font.family()) {
            font2.family = this.family;
        }
        if (this.size != font.size()) {
            font2.size = this.size;
        }
        if (this.style != font.style() && this.style != -1) {
            font2.style = this.style;
            if (font.style() != -1) {
                font2.style -= this.style & font.style();
            }
        }
        if (this.color == null || !this.color.equals(font.color())) {
            font2.color = this.color;
        }
        return font2;
    }

    public int family() {
        return this.family;
    }

    public float size() {
        return this.size;
    }

    public int style() {
        return this.style;
    }

    public boolean isBold() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 1) == 1;
    }

    public boolean isItalic() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 2) == 2;
    }

    public boolean isUnderlined() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 4) == 4;
    }

    public boolean isStrikethru() {
        if (this.style == -1) {
            return false;
        }
        return (this.style & 8) == 8;
    }

    public Color color() {
        return this.color;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(" font=\"");
        switch (this.family) {
            case 0: {
                stringBuffer.append("Courier");
                break;
            }
            case 1: {
                stringBuffer.append("Helvetica");
                break;
            }
            case 2: {
                stringBuffer.append("Times New Roman");
                break;
            }
            case 3: {
                stringBuffer.append("Symbol");
                break;
            }
            case 4: {
                stringBuffer.append("ZapfDingbats");
                break;
            }
            default: {
                stringBuffer.append("default");
            }
        }
        if (this.size != -1.0f) {
            stringBuffer.append("\" size=\"");
            stringBuffer.append(this.size);
        }
        if (this.style != -1) {
            stringBuffer.append("\" style=\"");
            switch (this.style & 3) {
                case 0: {
                    stringBuffer.append("normal");
                    break;
                }
                case 1: {
                    stringBuffer.append("bold");
                    break;
                }
                case 2: {
                    stringBuffer.append("italic");
                    break;
                }
                case 3: {
                    stringBuffer.append("bold, italic");
                }
            }
        }
        if (this.color != null) {
            stringBuffer.append("\" red=\"");
            stringBuffer.append(this.color.getRed());
            stringBuffer.append("\" green=\"");
            stringBuffer.append(this.color.getGreen());
            stringBuffer.append("\" blue=\"");
            stringBuffer.append(this.color.getBlue());
        }
        return stringBuffer.append("\"").toString();
    }

    public BaseFont getBaseFont() {
        return this.baseFont;
    }
}

