/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.NTLMAuthSequence;

class NTLMAuthentication
extends AuthenticationInfo {
    static char NTLM_AUTH = (char)78;
    static boolean supported;
    private String hostname;
    private static String defaultDomain;
    PasswordAuthentication pw;
    String username;
    String ntdomain;
    String password;

    static {
        defaultDomain = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("os.name");
                supported = string.toUpperCase().startsWith("WINDOWS");
                if (!supported) {
                    return null;
                }
                String string2 = System.getProperty("http.auth.ntlm.domain");
                if (string2 == null) {
                    return "domain";
                }
                return string2;
            }
        });
    }

    private void init0() {
        this.hostname = (String)AccessController.doPrivileged(new PrivilegedAction(this){
            private final NTLMAuthentication this$0;

            public Object run() {
                String string;
                try {
                    string = InetAddress.getLocalHost().getHostName().toUpperCase();
                }
                catch (UnknownHostException unknownHostException) {
                    string = "localhost";
                }
                return string;
            }
            {
                this.this$0 = nTLMAuthentication;
            }
        });
        int n2 = this.hostname.indexOf(46);
        if (n2 != -1) {
            this.hostname = this.hostname.substring(0, n2);
        }
    }

    static boolean isSupported() {
        return supported;
    }

    boolean supportsPreemptiveAuthorization() {
        return false;
    }

    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-authorization";
    }

    boolean isAuthorizationStale(String string) {
        return false;
    }

    private void init(PasswordAuthentication passwordAuthentication) {
        this.pw = passwordAuthentication;
        if (passwordAuthentication != null) {
            String string = passwordAuthentication.getUserName();
            int n2 = string.indexOf(92);
            if (n2 == -1) {
                this.username = string;
                this.ntdomain = defaultDomain;
            } else {
                this.ntdomain = string.substring(0, n2).toUpperCase();
                this.username = string.substring(n2 + 1);
            }
            this.password = new String(passwordAuthentication.getPassword());
        } else {
            this.username = null;
            this.ntdomain = null;
            this.password = null;
        }
        this.init0();
    }

    public NTLMAuthentication(boolean bl2, String string, int n2, PasswordAuthentication passwordAuthentication) {
        super(bl2 ? (char)'p' : 's', NTLM_AUTH, string, n2, "");
        this.init(passwordAuthentication);
    }

    public NTLMAuthentication(boolean bl2, URL uRL, PasswordAuthentication passwordAuthentication) {
        super(bl2 ? (char)'p' : 's', NTLM_AUTH, uRL, "");
        this.init(passwordAuthentication);
    }

    String getHeaderValue(URL uRL, String string) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    synchronized boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser, String string) {
        try {
            if (!supported) {
                return false;
            }
            NTLMAuthSequence nTLMAuthSequence = (NTLMAuthSequence)httpURLConnection.authObj;
            if (nTLMAuthSequence == null) {
                nTLMAuthSequence = new NTLMAuthSequence(this.username, this.password, this.ntdomain);
                httpURLConnection.authObj = nTLMAuthSequence;
            }
            String string2 = "NTLM " + nTLMAuthSequence.getAuthHeader(string.length() > 6 ? string.substring(5) : null);
            httpURLConnection.setAuthenticationProperty(this.getHeaderName(), string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void checkResponse(String string, String string2, URL uRL) throws IOException {
    }
}

