/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.AWTError;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.rmi.MarshalledObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import sun.awt.AppContext;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.image.ImageRepresentation;
import sun.io.CharToByteConverter;
import sun.io.CharacterEncoding;
import sun.security.action.GetPropertyAction;

public abstract class DataTransferer {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$datatransfer$DataTransferer == null ? (class$sun$awt$datatransfer$DataTransferer = DataTransferer.class$("sun.awt.datatransfer.DataTransferer")) : class$sun$awt$datatransfer$DataTransferer);
    public static final Class charArrayClass;
    public static final Class byteArrayClass;
    public static final DataFlavor plainTextStringFlavor;
    public static final DataFlavor javaTextEncodingFlavor;
    private static SortedSet standardEncodings;
    private static final Map knownEncodings;
    private static final Map textMIMESubtypeCharsetSupport;
    private static String defaultEncoding;
    private static final Set textNatives;
    private static final Map nativeCharsets;
    private static final Map nativeEOLNs;
    private static final Map nativeTerminators;
    private static final String DATA_CONVERTER_KEY = "DATA_CONVERTER_KEY";
    private static DataTransferer transferer;
    private static final String[] DEPLOYMENT_CACHE_PROPERTIES;
    private static final ArrayList deploymentCacheDirectoryList;
    private static CharsetComparator defaultCharsetComparator;
    private static DataFlavorComparator defaultFlavorComparator;
    static Class class$sun$awt$datatransfer$DataTransferer;
    static Class class$java$lang$String;
    static Class class$java$io$Reader;
    static Class class$java$nio$CharBuffer;
    static Class class$java$nio$ByteBuffer;
    static Class class$java$io$InputStream;
    static Class class$java$io$Serializable;
    static Class class$java$rmi$Remote;

    static {
        textNatives = Collections.synchronizedSet(new HashSet());
        nativeCharsets = Collections.synchronizedMap(new HashMap());
        nativeEOLNs = Collections.synchronizedMap(new HashMap());
        nativeTerminators = Collections.synchronizedMap(new HashMap());
        Class clazz = null;
        Class clazz2 = null;
        try {
            clazz = Class.forName("[C");
            clazz2 = Class.forName("[B");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        charArrayClass = clazz;
        byteArrayClass = clazz2;
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("text/plain;charset=Unicode;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        plainTextStringFlavor = dataFlavor;
        DataFlavor dataFlavor2 = null;
        try {
            dataFlavor2 = new DataFlavor("application/x-java-text-encoding;class=\"[B\"");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        javaTextEncodingFlavor = dataFlavor2;
        HashMap hashMap = new HashMap(11);
        hashMap.put("ASCII", Boolean.TRUE);
        hashMap.put("ISO8859_1", Boolean.TRUE);
        hashMap.put("UTF8", Boolean.TRUE);
        hashMap.put("UnicodeBigUnmarked", Boolean.TRUE);
        hashMap.put("UnicodeLittleUnmarked", Boolean.TRUE);
        hashMap.put("UTF16", Boolean.TRUE);
        knownEncodings = Collections.synchronizedMap(hashMap);
        hashMap = new HashMap(17);
        hashMap.put("sgml", Boolean.TRUE);
        hashMap.put("xml", Boolean.TRUE);
        hashMap.put("html", Boolean.TRUE);
        hashMap.put("enriched", Boolean.TRUE);
        hashMap.put("richtext", Boolean.TRUE);
        hashMap.put("uri-list", Boolean.TRUE);
        hashMap.put("directory", Boolean.TRUE);
        hashMap.put("css", Boolean.TRUE);
        hashMap.put("calendar", Boolean.TRUE);
        hashMap.put("plain", Boolean.TRUE);
        hashMap.put("rtf", Boolean.FALSE);
        hashMap.put("tab-separated-values", Boolean.FALSE);
        hashMap.put("t140", Boolean.FALSE);
        hashMap.put("rfc822-headers", Boolean.FALSE);
        hashMap.put("parityfec", Boolean.FALSE);
        textMIMESubtypeCharsetSupport = Collections.synchronizedMap(hashMap);
        DEPLOYMENT_CACHE_PROPERTIES = new String[]{"deployment.system.cachedir", "deployment.user.cachedir", "deployment.javaws.cachedir", "deployment.javapi.cachedir"};
        deploymentCacheDirectoryList = new ArrayList();
        defaultCharsetComparator = new CharsetComparator(false);
        defaultFlavorComparator = new DataFlavorComparator(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataConversionRequests() {
        if (EventQueue.isDispatchThread()) {
            AppContext appContext = AppContext.getAppContext();
            this.getToolkitThreadBlockedHandler().lock();
            try {
                Runnable runnable = (Runnable)appContext.get(DATA_CONVERTER_KEY);
                if (runnable != null) {
                    runnable.run();
                    appContext.remove(DATA_CONVERTER_KEY);
                }
            }
            finally {
                this.getToolkitThreadBlockedHandler().unlock();
            }
        }
    }

    public abstract boolean isFileFormat(long var1);

    public abstract boolean isImageFormat(long var1);

    public abstract boolean isLocaleDependentTextFormat(long var1);

    private boolean isTextFormat(long l2) {
        return textNatives.contains(new Long(l2));
    }

    protected abstract byte[] imageToPlatformBytes(Image var1, long var2) throws IOException;

    public static boolean doesSubtypeSupportCharset(DataFlavor dataFlavor) {
        String string = dataFlavor.getSubType();
        if (string == null) {
            return false;
        }
        Object object = textMIMESubtypeCharsetSupport.get(string);
        if (object != null) {
            return object == Boolean.TRUE;
        }
        boolean bl2 = dataFlavor.getParameter("charset") != null;
        textMIMESubtypeCharsetSupport.put(string, bl2 ? Boolean.TRUE : Boolean.FALSE);
        return bl2;
    }

    public static boolean isFlavorCharsetTextType(DataFlavor dataFlavor) {
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return true;
        }
        if (!"text".equals(dataFlavor.getPrimaryType()) || !DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
            return false;
        }
        Class clazz = dataFlavor.getRepresentationClass();
        if (dataFlavor.isRepresentationClassReader() || (class$java$lang$String == null ? (class$java$lang$String = DataTransferer.class$("java.lang.String")) : class$java$lang$String).equals(clazz) || dataFlavor.isRepresentationClassCharBuffer() || charArrayClass.equals(clazz)) {
            return true;
        }
        if (!(dataFlavor.isRepresentationClassInputStream() || dataFlavor.isRepresentationClassByteBuffer() || byteArrayClass.equals(clazz))) {
            return false;
        }
        String string = dataFlavor.getParameter("charset");
        return string != null ? DataTransferer.isEncodingSupported(string) : true;
    }

    public static boolean isFlavorNoncharsetTextType(DataFlavor dataFlavor) {
        if (!"text".equals(dataFlavor.getPrimaryType()) || DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
            return false;
        }
        return dataFlavor.isRepresentationClassInputStream() || dataFlavor.isRepresentationClassByteBuffer() || byteArrayClass.equals(dataFlavor.getRepresentationClass());
    }

    static boolean access$100(File file) {
        return DataTransferer.isFileInWebstartedCache(file);
    }

    private static boolean isFileInWebstartedCache(File file) {
        Object object;
        Object object2;
        if (deploymentCacheDirectoryList.isEmpty()) {
            for (int i2 = 0; i2 < DEPLOYMENT_CACHE_PROPERTIES.length; ++i2) {
                object2 = DEPLOYMENT_CACHE_PROPERTIES[i2];
                object = System.getProperty((String)object2);
                if (object == null) continue;
                try {
                    File file2 = new File((String)object).getCanonicalFile();
                    if (file2 == null) continue;
                    deploymentCacheDirectoryList.add(file2);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Iterator iterator = deploymentCacheDirectoryList.iterator();
        while (iterator.hasNext()) {
            object2 = (File)iterator.next();
            for (object = file; object != null; object = ((File)object).getParentFile()) {
                if (!((File)object).equals(object2)) continue;
                return true;
            }
        }
        return false;
    }

    protected static byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        byte[] byArray = new byte[8192];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String getDefaultTextCharset() {
        if (defaultEncoding != null) {
            return defaultEncoding;
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("file.encoding");
        String string = (String)AccessController.doPrivileged(getPropertyAction);
        if (string != null) {
            defaultEncoding = DataTransferer.canonicalName(string);
            if (!DataTransferer.isEncodingSupported(defaultEncoding)) {
                defaultEncoding = "ISO8859_1";
            }
            return defaultEncoding;
        }
        return "ISO8859_1";
    }

    public abstract String getDefaultUnicodeEncoding();

    protected abstract String getNativeForFormat(long var1);

    public static boolean isEncodingSupported(String string) {
        if (string == null) {
            return false;
        }
        String string2 = DataTransferer.canonicalName(string);
        Boolean bl2 = (Boolean)knownEncodings.get(string2);
        if (bl2 == null) {
            try {
                new String("abc".getBytes(string2), string2);
                bl2 = Boolean.TRUE;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bl2 = Boolean.FALSE;
            }
            knownEncodings.put(string2, bl2);
        }
        return bl2 == Boolean.TRUE;
    }

    private native String[] dragQueryFile(byte[] var1);

    public static Iterator standardEncodings() {
        if (standardEncodings == null) {
            TreeSet treeSet = new TreeSet(defaultCharsetComparator);
            treeSet.add("US-ASCII");
            treeSet.add("ISO-8859-1");
            treeSet.add("UTF-8");
            treeSet.add("UTF-16BE");
            treeSet.add("UTF-16LE");
            treeSet.add("UTF-16");
            treeSet.add(DataTransferer.getDefaultTextCharset());
            standardEncodings = Collections.unmodifiableSortedSet(treeSet);
        }
        return standardEncodings.iterator();
    }

    static Map access$300() {
        return nativeCharsets;
    }

    static Map access$400() {
        return nativeEOLNs;
    }

    static Map access$500() {
        return nativeTerminators;
    }

    public static long[] keysToLongArray(Map map) {
        Set set = map.keySet();
        long[] lArray = new long[set.size()];
        int n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            lArray[n2] = (Long)iterator.next();
            ++n2;
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataTransferer getInstance() {
        if (transferer == null) {
            Class clazz = class$sun$awt$datatransfer$DataTransferer == null ? (class$sun$awt$datatransfer$DataTransferer = DataTransferer.class$("sun.awt.datatransfer.DataTransferer")) : class$sun$awt$datatransfer$DataTransferer;
            synchronized (clazz) {
                String string;
                if (transferer == null && (string = SunToolkit.getDataTransfererClassName()) != null) {
                    PrivilegedAction privilegedAction = new PrivilegedAction(string){
                        private final String val$name;

                        public Object run() {
                            Object object;
                            Method method;
                            Class clazz;
                            block11: {
                                clazz = null;
                                method = null;
                                object = null;
                                try {
                                    clazz = Class.forName(this.val$name);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                                    if (classLoader == null) break block11;
                                    try {
                                        clazz = classLoader.loadClass(this.val$name);
                                    }
                                    catch (ClassNotFoundException classNotFoundException2) {
                                        classNotFoundException2.printStackTrace();
                                        throw new AWTError("DataTransferer not found: " + this.val$name);
                                    }
                                }
                            }
                            if (clazz != null) {
                                try {
                                    method = clazz.getMethod("getInstanceImpl", null);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    noSuchMethodException.printStackTrace();
                                    throw new AWTError("Cannot instantiate DataTransferer: " + this.val$name);
                                }
                            }
                            if (method != null) {
                                try {
                                    object = method.invoke(null, null);
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    invocationTargetException.printStackTrace();
                                    throw new AWTError("Cannot instantiate DataTransferer: " + this.val$name);
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    illegalAccessException.printStackTrace();
                                    throw new AWTError("Cannot access DataTransferer: " + this.val$name);
                                }
                            }
                            return object;
                        }
                        {
                            this.val$name = string;
                        }
                    };
                    transferer = (DataTransferer)AccessController.doPrivileged(privilegedAction);
                }
            }
        }
        return transferer;
    }

    public abstract ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler();

    protected abstract Image platformImageBytesOrStreamToImage(InputStream var1, byte[] var2, long var3) throws IOException;

    public DataFlavor[] getFlavorsForFormatAsArray(long l2, FlavorTable flavorTable) {
        return this.getFlavorsForFormatsAsArray(new long[]{l2}, flavorTable);
    }

    public DataFlavor[] getFlavorsForFormatsAsArray(long[] lArray, FlavorTable flavorTable) {
        return DataTransferer.setToSortedDataFlavorArray(this.getFlavorsForFormatsAsSet(lArray, flavorTable));
    }

    public byte[] translateTransferable(Transferable transferable, DataFlavor dataFlavor, long l2) throws IOException {
        Object object;
        boolean bl2;
        Object object2;
        try {
            object2 = transferable.getTransferData(dataFlavor);
            if (object2 == null) {
                return null;
            }
            if (dataFlavor.equals(DataFlavor.plainTextFlavor) && !(object2 instanceof InputStream)) {
                object2 = transferable.getTransferData(DataFlavor.stringFlavor);
                if (object2 == null) {
                    return null;
                }
                bl2 = true;
            } else {
                bl2 = false;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            throw new IOException(unsupportedFlavorException.getMessage());
        }
        if (bl2 || (class$java$lang$String == null ? (class$java$lang$String = DataTransferer.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass()) && DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
            int n2;
            String string = (String)object2;
            string = this.removeSuspectedData(dataFlavor, transferable, string);
            Long l3 = new Long(l2);
            String string2 = (String)nativeCharsets.get(l3);
            if (string2 == null) {
                string2 = DataTransferer.getDefaultTextCharset();
            }
            String string3 = (String)nativeEOLNs.get(l3);
            Integer n3 = (Integer)nativeTerminators.get(l3);
            if (string3 != null) {
                int n4 = string.length();
                StringBuffer stringBuffer = new StringBuffer(n4 * 2);
                for (int i2 = 0; i2 < n4; ++i2) {
                    n2 = string.charAt(i2);
                    if (n2 == 10) {
                        stringBuffer.append(string3);
                        continue;
                    }
                    stringBuffer.append((char)n2);
                }
                string = stringBuffer.toString();
            }
            byte[] byArray = string.getBytes(string2);
            if (n3 != null) {
                int n5 = n3;
                byte[] byArray2 = new byte[byArray.length + n5];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                for (n2 = byArray.length; n2 < byArray2.length; ++n2) {
                    byArray2[n2] = 0;
                }
                byArray = byArray2;
            }
            return byArray;
        }
        if (dataFlavor.isRepresentationClassReader()) {
            int n6;
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l2)) {
                throw new IOException("cannot transfer non-text data as Reader");
            }
            Reader reader = (Reader)object2;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n6 = reader.read()) != -1) {
                stringBuffer.append((char)n6);
            }
            reader.close();
            return this.translateTransferable(new StringSelection(stringBuffer.toString()), DataFlavor.plainTextFlavor, l2);
        }
        if (dataFlavor.isRepresentationClassCharBuffer()) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l2)) {
                throw new IOException("cannot transfer non-text data as CharBuffer");
            }
            CharBuffer charBuffer = (CharBuffer)object2;
            int n7 = charBuffer.remaining();
            char[] cArray = new char[n7];
            charBuffer.get(cArray, 0, n7);
            return this.translateTransferable(new StringSelection(new String(cArray)), DataFlavor.plainTextFlavor, l2);
        }
        if (charArrayClass.equals(dataFlavor.getRepresentationClass())) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l2)) {
                throw new IOException("cannot transfer non-text data as char array");
            }
            return this.translateTransferable(new StringSelection(new String((char[])object2)), DataFlavor.plainTextFlavor, l2);
        }
        if (dataFlavor.isRepresentationClassByteBuffer()) {
            ByteBuffer byteBuffer = (ByteBuffer)object2;
            int n8 = byteBuffer.remaining();
            byte[] byArray = new byte[n8];
            byteBuffer.get(byArray, 0, n8);
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
                String string = DataTransferer.getTextCharset(dataFlavor);
                return this.translateTransferable(new StringSelection(new String(byArray, string)), DataFlavor.plainTextFlavor, l2);
            }
            return byArray;
        }
        if (byteArrayClass.equals(dataFlavor.getRepresentationClass())) {
            byte[] byArray = (byte[])object2;
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
                String string = DataTransferer.getTextCharset(dataFlavor);
                return this.translateTransferable(new StringSelection(new String(byArray, string)), DataFlavor.plainTextFlavor, l2);
            }
            return byArray;
        }
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            if (!this.isImageFormat(l2)) {
                throw new IOException("Data translation failed: not an image format");
            }
            Image image = (Image)object2;
            byte[] byArray = this.imageToPlatformBytes(image, l2);
            if (byArray == null) {
                throw new IOException("Data translation failed: cannot convert java image to native format");
            }
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.isFileFormat(l2)) {
            Object object3;
            int n9;
            if (!DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                throw new IOException("data translation failed");
            }
            object = (List)object2;
            ArrayList arrayList = new ArrayList();
            ProtectionDomain protectionDomain = DataTransferer.getUserProtactionDomain(transferable);
            int n10 = 0;
            for (n9 = 0; n9 < object.size(); ++n9) {
                object3 = object.get(n9);
                if (!(object3 instanceof File) && !(object3 instanceof String)) continue;
                ++n10;
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(this, (List)object, protectionDomain, arrayList){
                    private final List val$list;
                    private final ProtectionDomain val$userProtectionDomain;
                    private final ArrayList val$fileList;
                    private final DataTransferer this$0;

                    public Object run() throws IOException {
                        boolean bl2 = false;
                        for (int i2 = 0; i2 < this.val$list.size(); ++i2) {
                            Object object = this.val$list.get(i2);
                            File file = DataTransferer.access$000(this.this$0, object);
                            if (null != System.getSecurityManager() && (DataTransferer.access$100(file) || DataTransferer.access$200(this.this$0, file, this.val$userProtectionDomain))) continue;
                            this.val$fileList.add(file.getCanonicalPath());
                        }
                        return null;
                    }
                    {
                        this.this$0 = dataTransferer;
                        this.val$list = list;
                        this.val$userProtectionDomain = protectionDomain;
                        this.val$fileList = arrayList;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new IOException(privilegedActionException.getMessage());
            }
            for (n9 = 0; n9 < arrayList.size(); ++n9) {
                object3 = ((String)arrayList.get(n9)).getBytes();
                byteArrayOutputStream.write((byte[])object3, 0, ((Object)object3).length);
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(0);
        } else if (dataFlavor.isRepresentationClassInputStream()) {
            object = (InputStream)object2;
            boolean bl3 = false;
            int n11 = ((InputStream)object).available();
            byte[] byArray = new byte[n11 > 8192 ? n11 : 8192];
            do {
                int n12;
                if (bl3 = (n12 = ((InputStream)object).read(byArray, 0, byArray.length)) == -1) continue;
                byteArrayOutputStream.write(byArray, 0, n12);
            } while (!bl3);
            ((InputStream)object).close();
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
                byte[] byArray3 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                String string = DataTransferer.getTextCharset(dataFlavor);
                return this.translateTransferable(new StringSelection(new String(byArray3, string)), DataFlavor.plainTextFlavor, l2);
            }
        } else if (dataFlavor.isRepresentationClassRemote()) {
            object = new MarshalledObject(object2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        } else if (dataFlavor.isRepresentationClassSerializable()) {
            object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeObject(object2);
            ((ObjectOutputStream)object).close();
        } else {
            throw new IOException("data translation failed");
        }
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return object;
    }

    public static DataFlavor[] keysToDataFlavorArray(Map map) {
        return DataTransferer.setToSortedDataFlavorArray(map.keySet(), map);
    }

    public static DataFlavor[] setToSortedDataFlavorArray(Set set) {
        Object[] objectArray = new DataFlavor[set.size()];
        set.toArray(objectArray);
        Arrays.sort(objectArray, defaultFlavorComparator);
        return objectArray;
    }

    public long[] getFormatsForFlavorAsArray(DataFlavor dataFlavor, FlavorTable flavorTable) {
        return DataTransferer.keysToLongArray(this.getFormatsForFlavor(dataFlavor, flavorTable));
    }

    public long[] getFormatsForFlavorsAsArray(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        return DataTransferer.keysToLongArray(this.getFormatsForFlavors(dataFlavorArray, flavorTable));
    }

    public static FlavorTable adaptFlavorMap(FlavorMap flavorMap) {
        if (flavorMap instanceof FlavorTable) {
            return (FlavorTable)flavorMap;
        }
        return new FlavorTable(flavorMap){
            private final FlavorMap val$map;
            {
                this.val$map = flavorMap;
            }

            public List getNativesForFlavor(DataFlavor dataFlavor) {
                Map map = this.getNativesForFlavors(new DataFlavor[]{dataFlavor});
                String string = (String)map.get(dataFlavor);
                if (string != null) {
                    ArrayList arrayList = new ArrayList(1);
                    arrayList.add(string);
                    return arrayList;
                }
                return Collections.EMPTY_LIST;
            }

            public List getFlavorsForNative(String string) {
                Map map = this.getFlavorsForNatives(new String[]{string});
                DataFlavor dataFlavor = (DataFlavor)map.get(string);
                if (dataFlavor != null) {
                    ArrayList arrayList = new ArrayList(1);
                    arrayList.add(dataFlavor);
                    return arrayList;
                }
                return Collections.EMPTY_LIST;
            }

            public Map getNativesForFlavors(DataFlavor[] dataFlavorArray) {
                return this.val$map.getNativesForFlavors(dataFlavorArray);
            }

            public Map getFlavorsForNatives(String[] stringArray) {
                return this.val$map.getFlavorsForNatives(stringArray);
            }
        };
    }

    public long[] getFormatsForTransferableAsArray(Transferable transferable, FlavorTable flavorTable) {
        return DataTransferer.keysToLongArray(this.getFormatsForTransferable(transferable, flavorTable));
    }

    private File castToFile(Object object) throws IOException {
        String string = null;
        if (object instanceof File) {
            string = ((File)object).getCanonicalPath();
        } else if (object instanceof String) {
            string = (String)object;
        }
        return new File(string);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected abstract Long getFormatForNativeAsLong(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] imageToStandardBytes(Image image, String string) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5 = null;
        Iterator iterator = ImageIO.getImageWritersByMIMEType(string);
        if (!iterator.hasNext()) {
            throw new IOException("No registered service provider can encode  an image to " + string);
        }
        if (image instanceof RenderedImage) {
            object5 = (RenderedImage)((Object)image);
        } else {
            int n2 = 0;
            int n3 = 0;
            if (image instanceof sun.awt.image.Image) {
                object4 = ((sun.awt.image.Image)image).getImageRep();
                ((ImageRepresentation)object4).reconstruct(32);
                n2 = ((ImageRepresentation)object4).getWidth();
                n3 = ((ImageRepresentation)object4).getHeight();
            } else {
                n2 = image.getWidth(null);
                n3 = image.getHeight(null);
            }
            object4 = ColorModel.getRGBdefault();
            object3 = ((ColorModel)object4).createCompatibleWritableRaster(n2, n3);
            object2 = new BufferedImage((ColorModel)object4, (WritableRaster)object3, ((ColorModel)object4).isAlphaPremultiplied(), null);
            object = ((BufferedImage)object2).getGraphics();
            try {
                ((Graphics)object).drawImage(image, 0, 0, n2, n3, null);
            }
            finally {
                ((Graphics)object).dispose();
            }
            object5 = object2;
        }
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier((RenderedImage)object5);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object4 = null;
        while (iterator.hasNext()) {
            object3 = (ImageWriter)iterator.next();
            object2 = ((ImageWriter)object3).getOriginatingProvider();
            if (!((ImageWriterSpi)object2).canEncodeImage(imageTypeSpecifier)) continue;
            try {
                object = ImageIO.createImageOutputStream(byteArrayOutputStream);
                try {
                    ((ImageWriter)object3).setOutput(object);
                    ((ImageWriter)object3).write((RenderedImage)object5);
                    object.flush();
                }
                finally {
                    object.close();
                }
            }
            catch (IOException iOException) {
                ((ImageWriter)object3).dispose();
                byteArrayOutputStream.reset();
                object4 = iOException;
                continue;
            }
            ((ImageWriter)object3).dispose();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        byteArrayOutputStream.close();
        if (object4 == null) {
            object4 = new IOException("Registered service providers failed to encode " + object5 + " to " + string);
        }
        throw object4;
    }

    public static String getTextCharset(DataFlavor dataFlavor) {
        if (!DataTransferer.isFlavorCharsetTextType(dataFlavor)) {
            return null;
        }
        String string = dataFlavor.getParameter("charset");
        return string != null ? string : DataTransferer.getDefaultTextCharset();
    }

    public static String canonicalName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = CharacterEncoding.aliasName(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static boolean doesSubtypeSupportCharset(String string, String string2) {
        Object object = textMIMESubtypeCharsetSupport.get(string);
        if (object != null) {
            return object == Boolean.TRUE;
        }
        boolean bl2 = string2 != null;
        textMIMESubtypeCharsetSupport.put(string, bl2 ? Boolean.TRUE : Boolean.FALSE);
        return bl2;
    }

    private static ProtectionDomain getUserProtactionDomain(Transferable transferable) {
        return transferable.getClass().getProtectionDomain();
    }

    private boolean isForbiddenToRead(File file, ProtectionDomain protectionDomain) {
        if (null == protectionDomain) {
            return false;
        }
        try {
            FilePermission filePermission = new FilePermission(file.getCanonicalPath(), "read, delete");
            if (protectionDomain.implies(filePermission)) {
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public Map getFlavorsForFormat(long l2, FlavorTable flavorTable) {
        return this.getFlavorsForFormats(new long[]{l2}, flavorTable);
    }

    public Map getFlavorsForFormats(long[] lArray, FlavorTable flavorTable) {
        Object object;
        Object object2;
        Object object3;
        HashMap hashMap = new HashMap(lArray.length);
        HashSet hashSet = new HashSet(lArray.length);
        HashSet hashSet2 = new HashSet(lArray.length);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long l2 = lArray[i2];
            object3 = this.getNativeForFormat(l2);
            object2 = flavorTable.getFlavorsForNative((String)object3);
            object = object2.iterator();
            while (object.hasNext()) {
                DataFlavor dataFlavor = (DataFlavor)object.next();
                if (!dataFlavor.isFlavorTextType() && !dataFlavor.isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals(dataFlavor) && !dataFlavor.isRepresentationClassSerializable() && !dataFlavor.isRepresentationClassInputStream() && !dataFlavor.isRepresentationClassRemote()) continue;
                Long l3 = new Long(l2);
                Object object4 = DataTransferer.createMapping(l3, dataFlavor);
                hashMap.put(dataFlavor, l3);
                hashSet.add(object4);
                hashSet2.add(dataFlavor);
            }
        }
        Iterator iterator = hashSet2.iterator();
        block2: while (iterator.hasNext()) {
            DataFlavor dataFlavor = (DataFlavor)iterator.next();
            List list = flavorTable.getNativesForFlavor(dataFlavor);
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = this.getFormatForNativeAsLong((String)object3.next());
                object = DataTransferer.createMapping(object2, dataFlavor);
                if (!hashSet.contains(object)) continue;
                hashMap.put(dataFlavor, object2);
                continue block2;
            }
        }
        return hashMap;
    }

    public Set getFlavorsForFormatsAsSet(long[] lArray, FlavorTable flavorTable) {
        HashSet hashSet = new HashSet(lArray.length);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            String string = this.getNativeForFormat(lArray[i2]);
            List list = flavorTable.getFlavorsForNative(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DataFlavor dataFlavor = (DataFlavor)iterator.next();
                if (!dataFlavor.isFlavorTextType() && !dataFlavor.isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals(dataFlavor) && !dataFlavor.isRepresentationClassSerializable() && !dataFlavor.isRepresentationClassInputStream() && !dataFlavor.isRepresentationClassRemote()) continue;
                hashSet.add(dataFlavor);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Image standardImageBytesOrStreamToImage(InputStream inputStream, byte[] byArray, String string) throws IOException {
        Iterator iterator;
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(byArray);
        }
        if (!(iterator = ImageIO.getImageReadersByMIMEType(string)).hasNext()) {
            throw new IOException("No registered service provider can decode  an image from " + string);
        }
        IOException iOException = null;
        while (true) {
            if (!iterator.hasNext()) {
                if (iOException != null) throw iOException;
                iOException = new IOException("Registered service providers failed to decode an image from " + string);
                throw iOException;
            }
            ImageReader imageReader = (ImageReader)iterator.next();
            try {
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                try {
                    ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                    imageReader.setInput(imageInputStream, true, true);
                    BufferedImage bufferedImage = imageReader.read(imageReader.getMinIndex(), imageReadParam);
                    if (bufferedImage == null) continue;
                    BufferedImage bufferedImage2 = bufferedImage;
                    return bufferedImage2;
                }
                finally {
                    imageInputStream.close();
                    imageReader.dispose();
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                continue;
            }
            break;
        }
    }

    public static DataFlavor[] setToSortedDataFlavorArray(Set set, Map map) {
        Object[] objectArray = new DataFlavor[set.size()];
        set.toArray(objectArray);
        DataFlavorComparator dataFlavorComparator = new DataFlavorComparator(map, false);
        Arrays.sort(objectArray, dataFlavorComparator);
        return objectArray;
    }

    static File access$000(DataTransferer dataTransferer, Object object) throws IOException {
        return dataTransferer.castToFile(object);
    }

    public Object translateBytes(byte[] byArray, DataFlavor dataFlavor, long l2, Transferable transferable) throws IOException {
        return this.translateBytesOrStream(null, byArray, dataFlavor, l2, transferable);
    }

    private Object concatData(Object object, Object object2) {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (object2 instanceof byte[]) {
                byte[] byArray2 = (byte[])object2;
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                return byArray3;
            }
            inputStream = new ByteArrayInputStream(byArray);
            inputStream2 = (InputStream)object2;
        } else {
            inputStream = (InputStream)object;
            inputStream2 = object2 instanceof byte[] ? new ByteArrayInputStream((byte[])object2) : (InputStream)object2;
        }
        return new SequenceInputStream(inputStream, inputStream2);
    }

    private static Object createMapping(Object object, Object object2) {
        return Arrays.asList(new Object[]{object, object2});
    }

    static boolean access$200(DataTransferer dataTransferer, File file, ProtectionDomain protectionDomain) {
        return dataTransferer.isForbiddenToRead(file, protectionDomain);
    }

    public Map getFormatsForFlavor(DataFlavor dataFlavor, FlavorTable flavorTable) {
        return this.getFormatsForFlavors(new DataFlavor[]{dataFlavor}, flavorTable);
    }

    public Map getFormatsForFlavors(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        HashMap hashMap = new HashMap(dataFlavorArray.length);
        HashMap hashMap2 = new HashMap(dataFlavorArray.length);
        for (int i2 = dataFlavorArray.length - 1; i2 >= 0; --i2) {
            DataFlavor dataFlavor = dataFlavorArray[i2];
            if (dataFlavor == null || !dataFlavor.isFlavorTextType() && !dataFlavor.isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals(dataFlavor) && !dataFlavor.isRepresentationClassSerializable() && !dataFlavor.isRepresentationClassInputStream() && !dataFlavor.isRepresentationClassRemote()) continue;
            List list = flavorTable.getNativesForFlavor(dataFlavor);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Long l2 = this.getFormatForNativeAsLong((String)iterator.next());
                hashMap.put(l2, dataFlavor);
                if ((!"text".equals(dataFlavor.getPrimaryType()) || !"plain".equals(dataFlavor.getSubType())) && !dataFlavor.equals(DataFlavor.stringFlavor)) continue;
                hashMap2.put(l2, dataFlavor);
            }
        }
        hashMap.putAll(hashMap2);
        return hashMap;
    }

    public Map getFormatsForTransferable(Transferable transferable, FlavorTable flavorTable) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        if (dataFlavorArray == null) {
            return new HashMap(0);
        }
        return this.getFormatsForFlavors(dataFlavorArray, flavorTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convertData(Object object, Transferable transferable, long l2, Map map, boolean bl2) throws IOException {
        byte[] byArray = null;
        if (bl2) {
            try {
                Stack stack = new Stack();
                Runnable runnable = new Runnable(this, map, l2, transferable, stack){
                    private boolean done;
                    private final Map val$formatMap;
                    private final long val$format;
                    private final Transferable val$contents;
                    private final Stack val$stack;
                    private final DataTransferer this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (this.done) {
                            return;
                        }
                        byte[] byArray = null;
                        try {
                            DataFlavor dataFlavor = (DataFlavor)this.val$formatMap.get(new Long(this.val$format));
                            if (dataFlavor != null) {
                                byArray = this.this$0.translateTransferable(this.val$contents, dataFlavor, this.val$format);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            byArray = null;
                        }
                        try {
                            this.this$0.getToolkitThreadBlockedHandler().lock();
                            this.val$stack.push(byArray);
                            this.this$0.getToolkitThreadBlockedHandler().exit();
                        }
                        finally {
                            this.this$0.getToolkitThreadBlockedHandler().unlock();
                            this.done = true;
                        }
                    }
                    {
                        this.this$0 = dataTransferer;
                        this.val$formatMap = map;
                        this.val$format = l2;
                        this.val$contents = transferable;
                        this.val$stack = stack;
                        this.done = false;
                    }
                };
                AppContext appContext = SunToolkit.targetToAppContext(object);
                this.getToolkitThreadBlockedHandler().lock();
                if (appContext != null) {
                    appContext.put(DATA_CONVERTER_KEY, runnable);
                }
                SunToolkit.executeOnEventHandlerThread(object, runnable);
                while (stack.empty()) {
                    this.getToolkitThreadBlockedHandler().enter();
                }
                if (appContext != null) {
                    appContext.remove(DATA_CONVERTER_KEY);
                }
                byArray = (byte[])stack.pop();
            }
            finally {
                this.getToolkitThreadBlockedHandler().unlock();
            }
        } else {
            DataFlavor dataFlavor = (DataFlavor)map.get(new Long(l2));
            if (dataFlavor != null) {
                byArray = this.translateTransferable(transferable, dataFlavor, l2);
            }
        }
        return byArray;
    }

    private Object translateBytesOrStreamToInputStream(InputStream inputStream, DataFlavor dataFlavor, long l2, Transferable transferable) throws IOException {
        if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
            inputStream = new ReencodingInputStream(this, inputStream, l2, DataTransferer.getTextCharset(dataFlavor), transferable);
        }
        return this.constructFlavoredObject(inputStream, dataFlavor, class$java$io$InputStream == null ? (class$java$io$InputStream = DataTransferer.class$("java.io.InputStream")) : class$java$io$InputStream);
    }

    public Object translateStream(InputStream inputStream, DataFlavor dataFlavor, long l2, Transferable transferable) throws IOException {
        return this.translateBytesOrStream(inputStream, null, dataFlavor, l2, transferable);
    }

    protected Object translateBytesOrStream(InputStream inputStream, byte[] byArray, DataFlavor dataFlavor, long l2, Transferable transferable) throws IOException {
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(byArray);
        }
        if (this.isFileFormat(l2)) {
            String[] stringArray;
            if (!DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                throw new IOException("data translation failed");
            }
            if (byArray == null) {
                byArray = DataTransferer.inputStreamToByteArray(inputStream);
            }
            if ((stringArray = this.dragQueryFile(byArray)) == null) {
                inputStream.close();
                return null;
            }
            Object[] objectArray = new File[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                objectArray[i2] = new File(stringArray[i2]);
            }
            inputStream.close();
            return Arrays.asList(objectArray);
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = DataTransferer.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass()) && DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
            int n2;
            if (byArray == null) {
                byArray = DataTransferer.inputStreamToByteArray(inputStream);
            }
            inputStream.close();
            Long l3 = new Long(l2);
            String string = null;
            if (this.isLocaleDependentTextFormat(l2) && transferable != null && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    string = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {}
            } else {
                string = (String)nativeCharsets.get(l3);
            }
            if (string == null) {
                string = DataTransferer.getDefaultTextCharset();
            }
            String string2 = (String)nativeEOLNs.get(l3);
            Integer n3 = (Integer)nativeTerminators.get(l3);
            if (n3 != null) {
                int n4 = n3;
                block7: for (n2 = 0; n2 < byArray.length - n4 + 1; n2 += n4) {
                    for (int i3 = n2; i3 < n2 + n4; ++i3) {
                        if (byArray[i3] != 0) continue block7;
                    }
                    break;
                }
            } else {
                n2 = byArray.length;
            }
            String string3 = new String(byArray, 0, n2, string);
            if (string2 != null) {
                char[] cArray = string3.toCharArray();
                char[] cArray2 = string2.toCharArray();
                string3 = null;
                int n5 = 0;
                int n6 = 0;
                while (n6 < cArray.length) {
                    if (n6 + cArray2.length > cArray.length) {
                        cArray[n5++] = cArray[n6++];
                        continue;
                    }
                    boolean bl2 = true;
                    int n7 = 0;
                    int n8 = n6;
                    while (n7 < cArray2.length) {
                        if (cArray2[n7] != cArray[n8]) {
                            bl2 = false;
                            break;
                        }
                        ++n7;
                        ++n8;
                    }
                    if (bl2) {
                        cArray[n5++] = 10;
                        n6 += cArray2.length;
                        continue;
                    }
                    cArray[n5++] = cArray[n6++];
                }
                string3 = new String(cArray, 0, n5);
            }
            return string3;
        }
        if (DataFlavor.plainTextFlavor.equals(dataFlavor)) {
            return new StringReader((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l2, transferable));
        }
        if (dataFlavor.isRepresentationClassInputStream()) {
            return this.translateBytesOrStreamToInputStream(inputStream, dataFlavor, l2, transferable);
        }
        if (dataFlavor.isRepresentationClassReader()) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l2)) {
                throw new IOException("cannot transfer non-text data as Reader");
            }
            InputStream inputStream2 = (InputStream)this.translateBytesOrStreamToInputStream(inputStream, DataFlavor.plainTextFlavor, l2, transferable);
            String string = DataTransferer.getTextCharset(DataFlavor.plainTextFlavor);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, string);
            return this.constructFlavoredObject(inputStreamReader, dataFlavor, class$java$io$Reader == null ? (class$java$io$Reader = DataTransferer.class$("java.io.Reader")) : class$java$io$Reader);
        }
        if (dataFlavor.isRepresentationClassCharBuffer()) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l2)) {
                throw new IOException("cannot transfer non-text data as CharBuffer");
            }
            CharBuffer charBuffer = CharBuffer.wrap((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l2, transferable));
            return this.constructFlavoredObject(charBuffer, dataFlavor, class$java$nio$CharBuffer == null ? (class$java$nio$CharBuffer = DataTransferer.class$("java.nio.CharBuffer")) : class$java$nio$CharBuffer);
        }
        if (charArrayClass.equals(dataFlavor.getRepresentationClass())) {
            if (!DataTransferer.isFlavorCharsetTextType(dataFlavor) || !this.isTextFormat(l2)) {
                throw new IOException("cannot transfer non-text data as char array");
            }
            return ((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l2, transferable)).toCharArray();
        }
        if (dataFlavor.isRepresentationClassByteBuffer()) {
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
                byArray = ((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l2, transferable)).getBytes(DataTransferer.getTextCharset(dataFlavor));
            } else if (byArray == null) {
                byArray = DataTransferer.inputStreamToByteArray(inputStream);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            return this.constructFlavoredObject(byteBuffer, dataFlavor, class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = DataTransferer.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer);
        }
        if (byteArrayClass.equals(dataFlavor.getRepresentationClass())) {
            if (DataTransferer.isFlavorCharsetTextType(dataFlavor) && this.isTextFormat(l2)) {
                return ((String)this.translateBytesOrStream(inputStream, byArray, plainTextStringFlavor, l2, transferable)).getBytes(DataTransferer.getTextCharset(dataFlavor));
            }
            return byArray != null ? byArray : DataTransferer.inputStreamToByteArray(inputStream);
        }
        if (dataFlavor.isRepresentationClassRemote()) {
            try {
                byte[] byArray2 = DataTransferer.inputStreamToByteArray(inputStream);
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray2));
                Object object = ((MarshalledObject)objectInputStream.readObject()).get();
                objectInputStream.close();
                inputStream.close();
                return object;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        if (dataFlavor.isRepresentationClassSerializable()) {
            try {
                byte[] byArray3 = DataTransferer.inputStreamToByteArray(inputStream);
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray3));
                Object object = objectInputStream.readObject();
                objectInputStream.close();
                inputStream.close();
                return object;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            if (!this.isImageFormat(l2)) {
                throw new IOException("data translation failed");
            }
            Image image = this.platformImageBytesOrStreamToImage(inputStream, byArray, l2);
            inputStream.close();
            return image;
        }
        throw new IOException("data translation failed");
    }

    private Object constructFlavoredObject(Object object, DataFlavor dataFlavor, Class clazz) throws IOException {
        Class clazz2 = dataFlavor.getRepresentationClass();
        if (clazz.equals(clazz2)) {
            return object;
        }
        Constructor[] constructorArray = null;
        try {
            constructorArray = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(this, clazz2){
                private final Class val$dfrc;
                private final DataTransferer this$0;

                public Object run() {
                    return this.val$dfrc.getConstructors();
                }
                {
                    this.this$0 = dataTransferer;
                    this.val$dfrc = clazz;
                }
            });
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getMessage());
        }
        Constructor constructor = null;
        for (int i2 = 0; i2 < constructorArray.length; ++i2) {
            Class[] classArray;
            if (!Modifier.isPublic(constructorArray[i2].getModifiers()) || (classArray = constructorArray[i2].getParameterTypes()) == null || classArray.length != 1 || !clazz.equals(classArray[0])) continue;
            constructor = constructorArray[i2];
            break;
        }
        if (constructor == null) {
            throw new IOException("can't find <init>(L" + clazz + ";)V for class: " + clazz2.getName());
        }
        try {
            return constructor.newInstance(new Object[]{object});
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private String removeSuspectedData(DataFlavor dataFlavor, Transferable transferable, String string) throws IOException {
        if (null == System.getSecurityManager() || !dataFlavor.isMimeTypeEqual("text/uri-list")) {
            return string;
        }
        String string2 = "";
        ProtectionDomain protectionDomain = DataTransferer.getUserProtactionDomain(transferable);
        try {
            string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(this, string, protectionDomain){
                private final String val$str;
                private final ProtectionDomain val$userProtectionDomain;
                private final DataTransferer this$0;

                public Object run() {
                    StringBuffer stringBuffer = new StringBuffer(this.val$str.length());
                    for (int i2 = 0; i2 < this.val$str.split("(\\s)+").length; ++i2) {
                        String string = this.val$str.split("(\\s)+")[i2];
                        File file = new File(string);
                        if (file.exists() && DataTransferer.access$100(file) || DataTransferer.access$200(this.this$0, file, this.val$userProtectionDomain)) continue;
                        if (0 != stringBuffer.length()) {
                            stringBuffer.append("\\r\\n");
                        }
                        stringBuffer.append(string);
                    }
                    return stringBuffer.toString();
                }
                {
                    this.this$0 = dataTransferer;
                    this.val$str = string;
                    this.val$userProtectionDomain = protectionDomain;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getMessage());
        }
        return string2;
    }

    public void registerTextFlavorProperties(String string, String string2, String string3, String string4) {
        Integer n2;
        Long l2 = this.getFormatForNativeAsLong(string);
        textNatives.add(l2);
        nativeCharsets.put(l2, string2 != null && string2.length() != 0 ? string2 : DataTransferer.getDefaultTextCharset());
        if (string3 != null && string3.length() != 0 && !string3.equals("\n")) {
            nativeEOLNs.put(l2, string3);
        }
        if (string4 != null && string4.length() != 0 && (n2 = Integer.valueOf(string4)) > 0) {
            nativeTerminators.put(l2, n2);
        }
    }

    public static class CharsetComparator
    extends IndexedComparator {
        private static final Map charsets;
        private static String defaultEncoding;
        private static final Integer DEFAULT_CHARSET_INDEX;
        private static final Integer OTHER_CHARSET_INDEX;
        private static final Integer WORST_CHARSET_INDEX;
        private static final Integer UNSUPPORTED_CHARSET_INDEX;
        private static final String UNSUPPORTED_CHARSET = "UNSUPPORTED";

        static {
            DEFAULT_CHARSET_INDEX = new Integer(2);
            OTHER_CHARSET_INDEX = new Integer(1);
            WORST_CHARSET_INDEX = new Integer(0);
            UNSUPPORTED_CHARSET_INDEX = new Integer(Integer.MIN_VALUE);
            HashMap hashMap = new HashMap(8, 1.0f);
            hashMap.put("Unicode", new Integer(3));
            hashMap.put("UnicodeLittleUnmarked", new Integer(4));
            hashMap.put("UnicodeBigUnmarked", new Integer(5));
            hashMap.put("UTF8", new Integer(6));
            hashMap.put("UTF16", new Integer(7));
            hashMap.put("ASCII", WORST_CHARSET_INDEX);
            String string = DataTransferer.canonicalName(DataTransferer.getDefaultTextCharset());
            if (hashMap.get(defaultEncoding) == null) {
                hashMap.put(defaultEncoding, DEFAULT_CHARSET_INDEX);
            }
            hashMap.put(UNSUPPORTED_CHARSET, UNSUPPORTED_CHARSET_INDEX);
            charsets = Collections.unmodifiableMap(hashMap);
        }

        public CharsetComparator() {
            this(true);
        }

        public CharsetComparator(boolean bl2) {
            super(bl2);
        }

        public int compare(Object object, Object object2) {
            String string = null;
            String string2 = null;
            if (this.order) {
                string = (String)object;
                string2 = (String)object2;
            } else {
                string = (String)object2;
                string2 = (String)object;
            }
            return this.compareCharsets(string, string2);
        }

        protected static String getEncoding(String string) {
            if (string == null) {
                return null;
            }
            if (!DataTransferer.isEncodingSupported(string)) {
                return UNSUPPORTED_CHARSET;
            }
            String string2 = DataTransferer.canonicalName(string);
            return charsets.containsKey(string2) ? string2 : string;
        }

        protected int compareCharsets(String string, String string2) {
            int n2 = CharsetComparator.compareIndices(charsets, string = CharsetComparator.getEncoding(string), string2 = CharsetComparator.getEncoding(string2), OTHER_CHARSET_INDEX);
            if (n2 == 0) {
                return string2.compareTo(string);
            }
            return n2;
        }
    }

    public static class DataFlavorComparator
    extends IndexedComparator {
        protected final Map flavorToFormatMap;
        private final CharsetComparator charsetComparator;
        private static final Map exactTypes;
        private static final Map primaryTypes;
        private static final Map nonTextRepresentations;
        private static final Map textTypes;
        private static final Map decodedTextRepresentations;
        private static final Map encodedTextRepresentations;
        private static final Integer UNKNOWN_OBJECT_LOSES;
        private static final Integer UNKNOWN_OBJECT_WINS;
        private static final Long UNKNOWN_OBJECT_LOSES_L;
        private static final Long UNKNOWN_OBJECT_WINS_L;

        static {
            UNKNOWN_OBJECT_LOSES = new Integer(Integer.MIN_VALUE);
            UNKNOWN_OBJECT_WINS = new Integer(Integer.MAX_VALUE);
            UNKNOWN_OBJECT_LOSES_L = new Long(Long.MIN_VALUE);
            UNKNOWN_OBJECT_WINS_L = new Long(Long.MAX_VALUE);
            HashMap hashMap = new HashMap(4, 1.0f);
            hashMap.put("application/x-java-file-list", new Integer(0));
            hashMap.put("application/x-java-serialized-object", new Integer(1));
            hashMap.put("application/x-java-jvm-local-objectref", new Integer(2));
            hashMap.put("application/x-java-remote-object", new Integer(3));
            exactTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(1, 1.0f);
            hashMap.put("application", new Integer(0));
            primaryTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(3, 1.0f);
            hashMap.put(class$java$io$InputStream == null ? (class$java$io$InputStream = DataTransferer.class$("java.io.InputStream")) : class$java$io$InputStream, new Integer(0));
            hashMap.put(class$java$io$Serializable == null ? (class$java$io$Serializable = DataTransferer.class$("java.io.Serializable")) : class$java$io$Serializable, new Integer(1));
            hashMap.put(class$java$rmi$Remote == null ? (class$java$rmi$Remote = DataTransferer.class$("java.rmi.Remote")) : class$java$rmi$Remote, new Integer(2));
            nonTextRepresentations = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(16, 1.0f);
            hashMap.put("text/plain", new Integer(0));
            hashMap.put("application/x-java-serialized-object", new Integer(1));
            hashMap.put("text/calendar", new Integer(2));
            hashMap.put("text/css", new Integer(3));
            hashMap.put("text/directory", new Integer(4));
            hashMap.put("text/parityfec", new Integer(5));
            hashMap.put("text/rfc822-headers", new Integer(6));
            hashMap.put("text/t140", new Integer(7));
            hashMap.put("text/tab-separated-values", new Integer(8));
            hashMap.put("text/uri-list", new Integer(9));
            hashMap.put("text/richtext", new Integer(10));
            hashMap.put("text/enriched", new Integer(11));
            hashMap.put("text/rtf", new Integer(12));
            hashMap.put("text/html", new Integer(13));
            hashMap.put("text/xml", new Integer(14));
            hashMap.put("text/sgml", new Integer(15));
            textTypes = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(4, 1.0f);
            hashMap.put(charArrayClass, new Integer(0));
            hashMap.put(class$java$nio$CharBuffer == null ? (class$java$nio$CharBuffer = DataTransferer.class$("java.nio.CharBuffer")) : class$java$nio$CharBuffer, new Integer(1));
            hashMap.put(class$java$lang$String == null ? (class$java$lang$String = DataTransferer.class$("java.lang.String")) : class$java$lang$String, new Integer(2));
            hashMap.put(class$java$io$Reader == null ? (class$java$io$Reader = DataTransferer.class$("java.io.Reader")) : class$java$io$Reader, new Integer(3));
            decodedTextRepresentations = Collections.unmodifiableMap(hashMap);
            hashMap = new HashMap(3, 1.0f);
            hashMap.put(byteArrayClass, new Integer(0));
            hashMap.put(class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = DataTransferer.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer, new Integer(1));
            hashMap.put(class$java$io$InputStream == null ? (class$java$io$InputStream = DataTransferer.class$("java.io.InputStream")) : class$java$io$InputStream, new Integer(2));
            encodedTextRepresentations = Collections.unmodifiableMap(hashMap);
        }

        public DataFlavorComparator() {
            this(true);
        }

        public DataFlavorComparator(boolean bl2) {
            super(bl2);
            this.charsetComparator = new CharsetComparator(bl2);
            this.flavorToFormatMap = Collections.EMPTY_MAP;
        }

        public DataFlavorComparator(Map map) {
            this(map, true);
        }

        public DataFlavorComparator(Map map, boolean bl2) {
            super(bl2);
            this.charsetComparator = new CharsetComparator(bl2);
            HashMap hashMap = new HashMap(map.size());
            hashMap.putAll(map);
            this.flavorToFormatMap = Collections.unmodifiableMap(hashMap);
        }

        public int compare(Object object, Object object2) {
            DataFlavor dataFlavor = null;
            DataFlavor dataFlavor2 = null;
            if (this.order) {
                dataFlavor = (DataFlavor)object;
                dataFlavor2 = (DataFlavor)object2;
            } else {
                dataFlavor = (DataFlavor)object2;
                dataFlavor2 = (DataFlavor)object;
            }
            if (dataFlavor.equals(dataFlavor2)) {
                return 0;
            }
            int n2 = 0;
            String string = dataFlavor.getPrimaryType();
            String string2 = dataFlavor.getSubType();
            String string3 = string + "/" + string2;
            Class clazz = dataFlavor.getRepresentationClass();
            String string4 = dataFlavor2.getPrimaryType();
            String string5 = dataFlavor2.getSubType();
            String string6 = string4 + "/" + string5;
            Class clazz2 = dataFlavor2.getRepresentationClass();
            if (dataFlavor.isFlavorTextType() && dataFlavor2.isFlavorTextType()) {
                n2 = DataFlavorComparator.compareIndices(textTypes, string3, string6, UNKNOWN_OBJECT_LOSES);
                if (n2 != 0) {
                    return n2;
                }
                if (DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
                    n2 = DataFlavorComparator.compareIndices(decodedTextRepresentations, clazz, clazz2, UNKNOWN_OBJECT_LOSES);
                    if (n2 != 0) {
                        return n2;
                    }
                    n2 = this.charsetComparator.compareCharsets(DataTransferer.getTextCharset(dataFlavor), DataTransferer.getTextCharset(dataFlavor2));
                    if (n2 != 0) {
                        return n2;
                    }
                }
                if ((n2 = DataFlavorComparator.compareIndices(encodedTextRepresentations, clazz, clazz2, UNKNOWN_OBJECT_LOSES)) != 0) {
                    return n2;
                }
            } else {
                n2 = DataFlavorComparator.compareIndices(primaryTypes, string, string4, UNKNOWN_OBJECT_LOSES);
                if (n2 != 0) {
                    return n2;
                }
                n2 = DataFlavorComparator.compareIndices(exactTypes, string3, string6, UNKNOWN_OBJECT_WINS);
                if (n2 != 0) {
                    return n2;
                }
                n2 = DataFlavorComparator.compareIndices(nonTextRepresentations, clazz, clazz2, UNKNOWN_OBJECT_LOSES);
                if (n2 != 0) {
                    return n2;
                }
            }
            return DataFlavorComparator.compareLongs(this.flavorToFormatMap, dataFlavor, dataFlavor2, UNKNOWN_OBJECT_LOSES_L);
        }
    }

    public static abstract class IndexedComparator
    implements Comparator {
        public static final boolean SELECT_BEST = true;
        public static final boolean SELECT_WORST = false;
        protected final boolean order;

        public IndexedComparator() {
            this(true);
        }

        public IndexedComparator(boolean bl2) {
            this.order = bl2;
        }

        protected static int compareIndices(Map map, Object object, Object object2, Integer n2) {
            Integer n3 = (Integer)map.get(object);
            Integer n4 = (Integer)map.get(object2);
            if (n3 == null) {
                n3 = n2;
            }
            if (n4 == null) {
                n4 = n2;
            }
            return n3.compareTo(n4);
        }

        protected static int compareLongs(Map map, Object object, Object object2, Long l2) {
            Long l3 = (Long)map.get(object);
            Long l4 = (Long)map.get(object2);
            if (l3 == null) {
                l3 = l2;
            }
            if (l4 == null) {
                l4 = l2;
            }
            return l3.compareTo(l4);
        }
    }

    public class ReencodingInputStream
    extends InputStream {
        protected BufferedReader wrapped;
        protected CharToByteConverter converter;
        protected final char[] in;
        protected byte[] out;
        protected CharsetEncoder encoder;
        protected CharBuffer inBuf;
        protected ByteBuffer outBuf;
        protected char[] eoln;
        protected int numTerminators;
        protected boolean eos;
        protected int index;
        protected int limit;
        private final DataTransferer this$0;

        public int available() throws IOException {
            return this.eos ? 0 : this.limit - this.index;
        }

        public int read() throws IOException {
            if (this.eos) {
                return -1;
            }
            if (this.index >= this.limit) {
                int n2 = this.wrapped.read();
                if (n2 == -1) {
                    this.eos = true;
                    return -1;
                }
                if (this.numTerminators > 0 && n2 == 0) {
                    this.eos = true;
                    return -1;
                }
                if (this.eoln != null && this.matchCharArray(this.eoln, n2)) {
                    n2 = 10;
                }
                this.in[0] = (char)n2;
                if (this.converter != null) {
                    this.limit = this.converter.convert(this.in, 0, 1, this.out, 0, this.out.length);
                } else {
                    this.inBuf.rewind();
                    this.outBuf.rewind();
                    this.encoder.encode(this.inBuf, this.outBuf, false);
                    this.limit = this.outBuf.limit();
                }
                this.index = 0;
                return this.read();
            }
            return this.out[this.index++] & 0xFF;
        }

        public void close() throws IOException {
            this.wrapped.close();
        }

        private boolean matchCharArray(char[] cArray, int n2) throws IOException {
            this.wrapped.mark(cArray.length);
            int n3 = 0;
            if ((char)n2 == cArray[0]) {
                for (n3 = 1; n3 < cArray.length && (n2 = this.wrapped.read()) != -1 && (char)n2 == cArray[n3]; ++n3) {
                }
            }
            if (n3 == cArray.length) {
                return true;
            }
            this.wrapped.reset();
            return false;
        }

        public ReencodingInputStream(DataTransferer dataTransferer, InputStream inputStream, long l2, String string, Transferable transferable) throws IOException {
            Integer n2;
            this.this$0 = dataTransferer;
            this.in = new char[1];
            Long l3 = new Long(l2);
            String string2 = null;
            if (dataTransferer.isLocaleDependentTextFormat(l2) && transferable != null && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    string2 = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {}
            } else {
                string2 = (String)DataTransferer.access$300().get(l3);
            }
            if (string2 == null) {
                string2 = DataTransferer.getDefaultTextCharset();
            }
            this.wrapped = new BufferedReader(new InputStreamReader(inputStream, string2));
            try {
                this.converter = CharToByteConverter.getConverter(string);
                this.out = new byte[this.converter.getMaxBytesPerChar()];
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    this.encoder = Charset.forName(string).newEncoder();
                    this.out = new byte[(int)((double)this.encoder.maxBytesPerChar() + 0.5)];
                    this.inBuf = CharBuffer.wrap(this.in);
                    this.outBuf = ByteBuffer.wrap(this.out);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    throw unsupportedEncodingException;
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    throw unsupportedEncodingException;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw unsupportedEncodingException;
                }
            }
            String string3 = (String)DataTransferer.access$400().get(l3);
            if (string3 != null) {
                this.eoln = string3.toCharArray();
            }
            if ((n2 = (Integer)DataTransferer.access$500().get(l3)) != null) {
                this.numTerminators = n2;
            }
        }
    }
}

