/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import sun.misc.ASCIICaseInsensitiveComparator;
import sun.misc.Service;
import sun.misc.ServiceConfigurationError;
import sun.misc.VM;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.ThreadLocalCoders;

public abstract class Charset
implements Comparable {
    private static CharsetProvider standardProvider = new StandardCharsets();
    private static volatile Object[] cache1 = null;
    private static volatile Object[] cache2 = null;
    private static ThreadLocal gate = new ThreadLocal();
    private static Object extendedProviderLock = new Object();
    private static boolean extendedProviderProbed = false;
    private static CharsetProvider extendedProvider = null;
    private final String name;
    private final String[] aliases;
    private Set aliasSet = null;
    static Class class$java$nio$charset$spi$CharsetProvider;

    public final int hashCode() {
        return this.name().hashCode();
    }

    private static void probeExtendedProvider() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class clazz = Class.forName("sun.nio.cs.ext.ExtendedCharsets");
                    Charset.access$102((CharsetProvider)clazz.newInstance());
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                    throw new Error(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new Error(illegalAccessException);
                }
                return null;
            }
        });
    }

    public boolean canEncode() {
        return true;
    }

    public final boolean isRegistered() {
        return !this.name.startsWith("X-") && !this.name.startsWith("x-");
    }

    public final int compareTo(Object object) {
        return this.name().compareToIgnoreCase(((Charset)object).name());
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Charset)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.name.equals(((Charset)object).name());
    }

    public String displayName() {
        return this.name;
    }

    public final String name() {
        return this.name;
    }

    public final String toString() {
        return this.name();
    }

    private static void checkName(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == ':' || c2 == '_' || c2 == '.') continue;
            throw new IllegalCharsetNameException(string);
        }
    }

    public static boolean isSupported(String string) {
        return Charset.lookup(string) != null;
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    static CharsetProvider access$200() {
        return standardProvider;
    }

    static Iterator access$000() {
        return Charset.providers();
    }

    private static Iterator providers() {
        return new Iterator(){
            Class c = class$java$nio$charset$spi$CharsetProvider == null ? (class$java$nio$charset$spi$CharsetProvider = Charset.class$("java.nio.charset.spi.CharsetProvider")) : class$java$nio$charset$spi$CharsetProvider;
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            Iterator i = Service.providers(this.c, this.cl);
            Object next = null;

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean getNext() {
                while (this.next == null) {
                    try {
                        if (!this.i.hasNext()) {
                            return false;
                        }
                        this.next = this.i.next();
                    }
                    catch (ServiceConfigurationError serviceConfigurationError) {
                        if (serviceConfigurationError.getCause() instanceof SecurityException) continue;
                        throw serviceConfigurationError;
                    }
                }
                return true;
            }

            public boolean hasNext() {
                return this.getNext();
            }

            public Object next() {
                if (!this.getNext()) {
                    throw new NoSuchElementException();
                }
                Object object = this.next;
                this.next = null;
                return object;
            }
        };
    }

    public final Set aliases() {
        if (this.aliasSet != null) {
            return this.aliasSet;
        }
        int n2 = this.aliases.length;
        HashSet hashSet = new HashSet(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            hashSet.add(this.aliases[i2]);
        }
        this.aliasSet = Collections.unmodifiableSet(hashSet);
        return this.aliasSet;
    }

    public static SortedMap availableCharsets() {
        return (SortedMap)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                TreeMap treeMap = new TreeMap(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
                Charset.access$300(Charset.access$200().charsets(), treeMap);
                Iterator iterator = Charset.access$000();
                while (iterator.hasNext()) {
                    CharsetProvider charsetProvider = (CharsetProvider)iterator.next();
                    Charset.access$300(charsetProvider.charsets(), treeMap);
                }
                return Collections.unmodifiableSortedMap(treeMap);
            }
        });
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected Charset(String string, String[] stringArray) {
        Charset.checkName(string);
        String[] stringArray2 = stringArray == null ? new String[]{} : stringArray;
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            Charset.checkName(stringArray2[i2]);
        }
        this.name = string;
        this.aliases = stringArray2;
    }

    public String displayName(Locale locale) {
        return this.name;
    }

    public final ByteBuffer encode(String string) {
        return this.encode(CharBuffer.wrap(string));
    }

    public final ByteBuffer encode(CharBuffer charBuffer) {
        try {
            return ThreadLocalCoders.encoderFor(this).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(charBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error(characterCodingException);
        }
    }

    public final CharBuffer decode(ByteBuffer byteBuffer) {
        try {
            return ThreadLocalCoders.decoderFor(this).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error(characterCodingException);
        }
    }

    public static Charset forName(String string) {
        Charset charset = Charset.lookup(string);
        if (charset != null) {
            return charset;
        }
        throw new UnsupportedCharsetException(string);
    }

    private static Charset lookup(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null charset name");
        }
        Object[] objectArray = cache1;
        if (cache1 != null && string.equals(objectArray[0])) {
            return (Charset)objectArray[1];
        }
        return Charset.lookup2(string);
    }

    private static Charset lookup2(String string) {
        Object[] objectArray = cache2;
        if (cache2 != null && string.equals(objectArray[0])) {
            cache2 = cache1;
            cache1 = objectArray;
            return (Charset)objectArray[1];
        }
        Charset charset = standardProvider.charsetForName(string);
        if (charset != null || (charset = Charset.lookupExtendedCharset(string)) != null || (charset = Charset.lookupViaProviders(string)) != null) {
            Charset.cache(string, charset);
            return charset;
        }
        Charset.checkName(string);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset lookupExtendedCharset(String string) {
        CharsetProvider charsetProvider = null;
        Object object = extendedProviderLock;
        synchronized (object) {
            if (!extendedProviderProbed) {
                Charset.probeExtendedProvider();
                extendedProviderProbed = true;
            }
            charsetProvider = extendedProvider;
        }
        return charsetProvider != null ? charsetProvider.charsetForName(string) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset lookupViaProviders(String string) {
        if (!VM.isBooted()) {
            return null;
        }
        if (gate.get() != null) {
            return null;
        }
        try {
            gate.set(gate);
            Charset charset = (Charset)AccessController.doPrivileged(new PrivilegedAction(string){
                private final String val$charsetName;

                public Object run() {
                    Iterator iterator = Charset.access$000();
                    while (iterator.hasNext()) {
                        CharsetProvider charsetProvider = (CharsetProvider)iterator.next();
                        Charset charset = charsetProvider.charsetForName(this.val$charsetName);
                        if (charset == null) continue;
                        return charset;
                    }
                    return null;
                }
                {
                    this.val$charsetName = string;
                }
            });
            return charset;
        }
        finally {
            gate.set(null);
        }
    }

    private static void cache(String string, Charset charset) {
        cache2 = cache1;
        cache1 = new Object[]{string, charset};
    }

    static CharsetProvider access$102(CharsetProvider charsetProvider) {
        extendedProvider = charsetProvider;
        return extendedProvider;
    }

    static void access$300(Iterator iterator, Map map) {
        Charset.put(iterator, map);
    }

    private static void put(Iterator iterator, Map map) {
        while (iterator.hasNext()) {
            Charset charset = (Charset)iterator.next();
            if (map.containsKey(charset.name())) continue;
            map.put(charset.name(), charset);
        }
    }
}

