/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.png.PNGImageDataEnumeration;
import com.sun.imageio.plugins.png.PNGMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class PNGImageReader
extends ImageReader {
    static final int IHDR_TYPE = PNGImageReader.chunkType("IHDR");
    static final int PLTE_TYPE = PNGImageReader.chunkType("PLTE");
    static final int IDAT_TYPE = PNGImageReader.chunkType("IDAT");
    static final int IEND_TYPE = PNGImageReader.chunkType("IEND");
    static final int bKGD_TYPE = PNGImageReader.chunkType("bKGD");
    static final int cHRM_TYPE = PNGImageReader.chunkType("cHRM");
    static final int gAMA_TYPE = PNGImageReader.chunkType("gAMA");
    static final int hIST_TYPE = PNGImageReader.chunkType("hIST");
    static final int iCCP_TYPE = PNGImageReader.chunkType("iCCP");
    static final int iTXt_TYPE = PNGImageReader.chunkType("iTXt");
    static final int pHYs_TYPE = PNGImageReader.chunkType("pHYs");
    static final int sBIT_TYPE = PNGImageReader.chunkType("sBIT");
    static final int sPLT_TYPE = PNGImageReader.chunkType("sPLT");
    static final int sRGB_TYPE = PNGImageReader.chunkType("sRGB");
    static final int tEXt_TYPE = PNGImageReader.chunkType("tEXt");
    static final int tIME_TYPE = PNGImageReader.chunkType("tIME");
    static final int tRNS_TYPE = PNGImageReader.chunkType("tRNS");
    static final int zTXt_TYPE = PNGImageReader.chunkType("zTXt");
    static final int PNG_COLOR_GRAY = 0;
    static final int PNG_COLOR_RGB = 2;
    static final int PNG_COLOR_PALETTE = 3;
    static final int PNG_COLOR_GRAY_ALPHA = 4;
    static final int PNG_COLOR_RGB_ALPHA = 6;
    static final int[] inputBandsForColorType = new int[]{1, -1, 3, 1, 2, -1, 4};
    static final int PNG_FILTER_NONE = 0;
    static final int PNG_FILTER_SUB = 1;
    static final int PNG_FILTER_UP = 2;
    static final int PNG_FILTER_AVERAGE = 3;
    static final int PNG_FILTER_PAETH = 4;
    static final int[] adam7XOffset = new int[]{0, 4, 0, 2, 0, 1, 0};
    static final int[] adam7YOffset = new int[]{0, 0, 4, 0, 2, 0, 1};
    static final int[] adam7XSubsampling = new int[]{8, 8, 4, 4, 2, 2, 1, 1};
    static final int[] adam7YSubsampling = new int[]{8, 8, 8, 4, 4, 2, 2, 1};
    private static final boolean debug = true;
    ImageInputStream stream = null;
    boolean gotHeader = false;
    boolean gotMetadata = false;
    ImageReadParam lastParam = null;
    long imageStartPosition = -1L;
    Rectangle sourceRegion = null;
    int sourceXSubsampling = -1;
    int sourceYSubsampling = -1;
    int sourceMinProgressivePass = 0;
    int sourceMaxProgressivePass = 6;
    int[] sourceBands = null;
    int[] destinationBands = null;
    Point destinationOffset = new Point(0, 0);
    PNGMetadata metadata = new PNGMetadata();
    DataInputStream pixelStream = null;
    BufferedImage theImage = null;
    int pixelsDone = 0;
    int totalPixels;
    private static final int[][] bandOffsets = new int[][]{null, {0}, {0, 1}, {0, 1, 2}, {0, 1, 2, 3}};

    private void decodeImage() throws IOException, IIOException {
        int n2 = this.metadata.IHDR_width;
        int n3 = this.metadata.IHDR_height;
        this.pixelsDone = 0;
        this.totalPixels = n2 * n3;
        this.clearAbortRequest();
        if (this.metadata.IHDR_interlaceMethod == 0) {
            this.decodePass(0, 0, 0, 1, 1, n2, n3);
        } else {
            for (int i2 = 0; i2 <= this.sourceMaxProgressivePass; ++i2) {
                int n4 = adam7XOffset[i2];
                int n5 = adam7YOffset[i2];
                int n6 = adam7XSubsampling[i2];
                int n7 = adam7YSubsampling[i2];
                int n8 = adam7XSubsampling[i2 + 1] - 1;
                int n9 = adam7YSubsampling[i2 + 1] - 1;
                if (i2 >= this.sourceMinProgressivePass) {
                    this.decodePass(i2, n4, n5, n6, n7, (n2 + n8) / n6, (n3 + n9) / n7);
                } else {
                    this.skipPass((n2 + n8) / n6, (n3 + n9) / n7);
                }
                if (!this.abortRequested()) continue;
                return;
            }
        }
    }

    private void parse_bKGD_chunk() throws IOException {
        if (this.metadata.IHDR_colorType == 3) {
            this.metadata.bKGD_colorType = 3;
            this.metadata.bKGD_index = this.stream.readUnsignedByte();
        } else if (this.metadata.IHDR_colorType == 0 || this.metadata.IHDR_colorType == 4) {
            this.metadata.bKGD_colorType = 0;
            this.metadata.bKGD_gray = this.stream.readUnsignedShort();
        } else {
            this.metadata.bKGD_colorType = 2;
            this.metadata.bKGD_red = this.stream.readUnsignedShort();
            this.metadata.bKGD_green = this.stream.readUnsignedShort();
            this.metadata.bKGD_blue = this.stream.readUnsignedShort();
        }
        this.metadata.bKGD_present = true;
    }

    private void parse_cHRM_chunk() throws IOException {
        this.metadata.cHRM_whitePointX = this.stream.readInt();
        this.metadata.cHRM_whitePointY = this.stream.readInt();
        this.metadata.cHRM_redX = this.stream.readInt();
        this.metadata.cHRM_redY = this.stream.readInt();
        this.metadata.cHRM_greenX = this.stream.readInt();
        this.metadata.cHRM_greenY = this.stream.readInt();
        this.metadata.cHRM_blueX = this.stream.readInt();
        this.metadata.cHRM_blueY = this.stream.readInt();
        this.metadata.cHRM_present = true;
    }

    private void parse_gAMA_chunk() throws IOException {
        int n2;
        this.metadata.gAMA_gamma = n2 = this.stream.readInt();
        this.metadata.gAMA_present = true;
    }

    private void parse_hIST_chunk() throws IOException, IIOException {
        if (!this.metadata.PLTE_present) {
            throw new IIOException("hIST chunk without prior PLTE chunk!");
        }
        this.metadata.hIST_histogram = new char[this.metadata.PLTE_red.length];
        this.stream.readFully(this.metadata.hIST_histogram, 0, this.metadata.hIST_histogram.length);
        this.metadata.hIST_present = true;
    }

    private void parse_pHYs_chunk() throws IOException {
        this.metadata.pHYs_pixelsPerUnitXAxis = this.stream.readInt();
        this.metadata.pHYs_pixelsPerUnitYAxis = this.stream.readInt();
        this.metadata.pHYs_unitSpecifier = this.stream.readUnsignedByte();
        this.metadata.pHYs_present = true;
    }

    private void parse_sBIT_chunk() throws IOException {
        int n2 = this.metadata.IHDR_colorType;
        if (n2 == 0 || n2 == 4) {
            this.metadata.sBIT_grayBits = this.stream.readUnsignedByte();
        } else if (n2 == 2 || n2 == 3 || n2 == 6) {
            this.metadata.sBIT_redBits = this.stream.readUnsignedByte();
            this.metadata.sBIT_greenBits = this.stream.readUnsignedByte();
            this.metadata.sBIT_blueBits = this.stream.readUnsignedByte();
        }
        if (n2 == 4 || n2 == 6) {
            this.metadata.sBIT_alphaBits = this.stream.readUnsignedByte();
        }
        this.metadata.sBIT_colorType = n2;
        this.metadata.sBIT_present = true;
    }

    private void parse_sRGB_chunk() throws IOException {
        this.metadata.sRGB_renderingIntent = this.stream.readUnsignedByte();
        this.metadata.sRGB_present = true;
    }

    private void parse_tIME_chunk() throws IOException {
        this.metadata.tIME_year = this.stream.readUnsignedShort();
        this.metadata.tIME_month = this.stream.readUnsignedByte();
        this.metadata.tIME_day = this.stream.readUnsignedByte();
        this.metadata.tIME_hour = this.stream.readUnsignedByte();
        this.metadata.tIME_minute = this.stream.readUnsignedByte();
        this.metadata.tIME_second = this.stream.readUnsignedByte();
        this.metadata.tIME_present = true;
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input source not set!");
        }
        try {
            byte[] byArray = new byte[8];
            this.stream.readFully(byArray);
            if (byArray[0] != -119 || byArray[1] != 80 || byArray[2] != 78 || byArray[3] != 71 || byArray[4] != 13 || byArray[5] != 10 || byArray[6] != 26 || byArray[7] != 10) {
                throw new IIOException("Bad PNG signature!");
            }
            int n2 = this.stream.readInt();
            if (n2 != 13) {
                throw new IIOException("Bad length for IHDR chunk!");
            }
            int n3 = this.stream.readInt();
            if (n3 != IHDR_TYPE) {
                throw new IIOException("Bad type for IHDR chunk!");
            }
            this.metadata = new PNGMetadata();
            int n4 = this.stream.readInt();
            int n5 = this.stream.readInt();
            int n6 = this.stream.readUnsignedByte();
            int n7 = this.stream.readUnsignedByte();
            int n8 = this.stream.readUnsignedByte();
            int n9 = this.stream.readUnsignedByte();
            int n10 = this.stream.readUnsignedByte();
            int n11 = this.stream.readInt();
            this.stream.flushBefore(this.stream.getStreamPosition());
            if (n4 == 0) {
                throw new IIOException("Image width == 0!");
            }
            if (n5 == 0) {
                throw new IIOException("Image height == 0!");
            }
            if (n6 != 1 && n6 != 2 && n6 != 4 && n6 != 8 && n6 != 16) {
                throw new IIOException("Bit depth must be 1, 2, 4, 8, or 16!");
            }
            if (n7 != 0 && n7 != 2 && n7 != 3 && n7 != 4 && n7 != 6) {
                throw new IIOException("Color type must be 0, 2, 3, 4, or 6!");
            }
            if (n7 == 3 && n6 == 16) {
                throw new IIOException("Bad color type/bit depth combination!");
            }
            if ((n7 == 2 || n7 == 6 || n7 == 4) && n6 != 8 && n6 != 16) {
                throw new IIOException("Bad color type/bit depth combination!");
            }
            if (n8 != 0) {
                throw new IIOException("Unknown compression method (not 0)!");
            }
            if (n9 != 0) {
                throw new IIOException("Unknown filter method (not 0)!");
            }
            if (n10 != 0 && n10 != 1) {
                throw new IIOException("Unknown interlace method (not 0 or 1)!");
            }
            this.metadata.IHDR_present = true;
            this.metadata.IHDR_width = n4;
            this.metadata.IHDR_height = n5;
            this.metadata.IHDR_bitDepth = n6;
            this.metadata.IHDR_colorType = n7;
            this.metadata.IHDR_compressionMethod = n8;
            this.metadata.IHDR_filterMethod = n9;
            this.metadata.IHDR_interlaceMethod = n10;
            this.gotHeader = true;
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading PNG header!", iOException);
        }
    }

    private void readMetadata() throws IIOException {
        if (this.gotMetadata) {
            return;
        }
        this.readHeader();
        try {
            while (true) {
                int n2 = this.stream.readInt();
                int n3 = this.stream.readInt();
                if (n3 == IDAT_TYPE) {
                    this.stream.skipBytes(-8);
                    this.imageStartPosition = this.stream.getStreamPosition();
                    break;
                }
                if (n3 == PLTE_TYPE) {
                    this.parse_PLTE_chunk(n2);
                } else if (n3 == bKGD_TYPE) {
                    this.parse_bKGD_chunk();
                } else if (n3 == cHRM_TYPE) {
                    this.parse_cHRM_chunk();
                } else if (n3 == gAMA_TYPE) {
                    this.parse_gAMA_chunk();
                } else if (n3 == hIST_TYPE) {
                    this.parse_hIST_chunk();
                } else if (n3 == iCCP_TYPE) {
                    this.parse_iCCP_chunk(n2);
                } else if (n3 == iTXt_TYPE) {
                    this.parse_iTXt_chunk(n2);
                } else if (n3 == pHYs_TYPE) {
                    this.parse_pHYs_chunk();
                } else if (n3 == sBIT_TYPE) {
                    this.parse_sBIT_chunk();
                } else if (n3 == sPLT_TYPE) {
                    this.parse_sPLT_chunk(n2);
                } else if (n3 == sRGB_TYPE) {
                    this.parse_sRGB_chunk();
                } else if (n3 == tEXt_TYPE) {
                    this.parse_tEXt_chunk(n2);
                } else if (n3 == tIME_TYPE) {
                    this.parse_tIME_chunk();
                } else if (n3 == tRNS_TYPE) {
                    this.parse_tRNS_chunk(n2);
                } else if (n3 == zTXt_TYPE) {
                    this.parse_zTXt_chunk(n2);
                } else {
                    byte[] byArray = new byte[n2];
                    this.stream.readFully(byArray);
                    StringBuffer stringBuffer = new StringBuffer(4);
                    stringBuffer.append((char)(n3 >>> 24));
                    stringBuffer.append((char)(n3 >> 16 & 0xFF));
                    stringBuffer.append((char)(n3 >> 8 & 0xFF));
                    stringBuffer.append((char)(n3 & 0xFF));
                    int n4 = n3 >>> 28;
                    if (n4 == 0) {
                        this.processWarningOccurred("Encountered unknown chunk with critical bit set!");
                    }
                    this.metadata.unknownChunkType.add(stringBuffer.toString());
                    this.metadata.unknownChunkData.add(byArray);
                }
                int n5 = this.stream.readInt();
                this.stream.flushBefore(this.stream.getStreamPosition());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IIOException("Error reading PNG metadata", iOException);
        }
        this.gotMetadata = true;
    }

    public void reset() {
        super.reset();
        this.resetStreamSettings();
    }

    private void resetStreamSettings() {
        this.gotHeader = false;
        this.gotMetadata = false;
        this.metadata = null;
        this.pixelStream = null;
    }

    public int getHeight(int n2) throws IIOException {
        this.readHeader();
        return this.metadata.IHDR_height;
    }

    public int getWidth(int n2) throws IIOException {
        this.readHeader();
        return this.metadata.IHDR_width;
    }

    private void parse_PLTE_chunk(int n2) throws IOException {
        int n3;
        if (this.metadata.PLTE_present) {
            this.processWarningOccurred("A PNG image may not contain more than one PLTE chunk.\nThe chunk wil be ignored.");
            return;
        }
        if (this.metadata.IHDR_colorType == 0 || this.metadata.IHDR_colorType == 4) {
            this.processWarningOccurred("A PNG gray or gray alpha image cannot have a PLTE chunk.\nThe chunk wil be ignored.");
            return;
        }
        byte[] byArray = new byte[n2];
        this.stream.readFully(byArray);
        int n4 = n2 / 3;
        if (this.metadata.IHDR_colorType == 3) {
            n3 = 1 << this.metadata.IHDR_bitDepth;
            if (n4 > n3) {
                this.processWarningOccurred("PLTE chunk contains too many entries for bit depth, ignoring extras.");
                n4 = n3;
            }
            n4 = Math.min(n4, n3);
        }
        n3 = n4 > 16 ? 256 : (n4 > 8 ? 16 : (n4 > 2 ? 4 : 2));
        this.metadata.PLTE_present = true;
        this.metadata.PLTE_red = new byte[n3];
        this.metadata.PLTE_green = new byte[n3];
        this.metadata.PLTE_blue = new byte[n3];
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            this.metadata.PLTE_red[i2] = byArray[n5++];
            this.metadata.PLTE_green[i2] = byArray[n5++];
            this.metadata.PLTE_blue[i2] = byArray[n5++];
        }
    }

    private void parse_iCCP_chunk(int n2) throws IOException {
        String string;
        this.metadata.iCCP_profileName = string = this.readNullTerminatedString();
        this.metadata.iCCP_compressionMethod = this.stream.readUnsignedByte();
        byte[] byArray = new byte[n2 - string.length() - 2];
        this.stream.readFully(byArray);
        this.metadata.iCCP_compressedProfile = byArray;
        this.metadata.iCCP_present = true;
    }

    private void parse_iTXt_chunk(int n2) throws IOException {
        String string;
        long l2 = this.stream.getStreamPosition();
        String string2 = this.readNullTerminatedString();
        this.metadata.iTXt_keyword.add(string2);
        int n3 = this.stream.readUnsignedByte();
        this.metadata.iTXt_compressionFlag.add(new Integer(n3));
        int n4 = this.stream.readUnsignedByte();
        this.metadata.iTXt_compressionMethod.add(new Integer(n4));
        String string3 = this.readNullTerminatedString();
        this.metadata.iTXt_languageTag.add(string3);
        String string4 = this.stream.readUTF();
        this.metadata.iTXt_translatedKeyword.add(string4);
        this.stream.skipBytes(1);
        if (n3 == 1) {
            long l3 = this.stream.getStreamPosition();
            byte[] byArray = new byte[(int)(l2 + (long)n2 - l3)];
            this.stream.readFully(byArray);
            string = PNGImageReader.inflate(byArray);
        } else {
            string = this.stream.readUTF();
        }
        this.metadata.iTXt_text.add(string);
    }

    private void parse_sPLT_chunk(int n2) throws IOException, IIOException {
        int n3;
        this.metadata.sPLT_paletteName = this.readNullTerminatedString();
        this.metadata.sPLT_sampleDepth = n3 = this.stream.readUnsignedByte();
        int n4 = (n2 -= this.metadata.sPLT_paletteName.length() + 1) / (4 * (n3 / 8) + 2);
        this.metadata.sPLT_red = new int[n4];
        this.metadata.sPLT_green = new int[n4];
        this.metadata.sPLT_blue = new int[n4];
        this.metadata.sPLT_alpha = new int[n4];
        this.metadata.sPLT_frequency = new int[n4];
        if (n3 == 8) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.metadata.sPLT_red[i2] = this.stream.readUnsignedByte();
                this.metadata.sPLT_green[i2] = this.stream.readUnsignedByte();
                this.metadata.sPLT_blue[i2] = this.stream.readUnsignedByte();
                this.metadata.sPLT_alpha[i2] = this.stream.readUnsignedByte();
                this.metadata.sPLT_frequency[i2] = this.stream.readUnsignedShort();
            }
        } else if (n3 == 16) {
            for (int i3 = 0; i3 < n4; ++i3) {
                this.metadata.sPLT_red[i3] = this.stream.readUnsignedShort();
                this.metadata.sPLT_green[i3] = this.stream.readUnsignedShort();
                this.metadata.sPLT_blue[i3] = this.stream.readUnsignedShort();
                this.metadata.sPLT_alpha[i3] = this.stream.readUnsignedShort();
                this.metadata.sPLT_frequency[i3] = this.stream.readUnsignedShort();
            }
        } else {
            throw new IIOException("sPLT sample depth not 8 or 16!");
        }
        this.metadata.sPLT_present = true;
    }

    private void parse_tEXt_chunk(int n2) throws IOException {
        String string = this.readNullTerminatedString();
        this.metadata.tEXt_keyword.add(string);
        byte[] byArray = new byte[n2 - string.length() - 1];
        this.stream.readFully(byArray);
        this.metadata.tEXt_text.add(new String(byArray));
    }

    private void parse_tRNS_chunk(int n2) throws IOException {
        int n3 = this.metadata.IHDR_colorType;
        if (n3 == 3) {
            if (!this.metadata.PLTE_present) {
                this.processWarningOccurred("tRNS chunk without prior PLTE chunk, ignoring it.");
                return;
            }
            int n4 = n2;
            int n5 = this.metadata.PLTE_red.length;
            if (n4 > n5) {
                this.processWarningOccurred("tRNS chunk has more entries than prior PLTE chunk, ignoring extras.");
                n4 = n5;
            }
            this.metadata.tRNS_alpha = new byte[n4];
            this.metadata.tRNS_colorType = 3;
            this.stream.read(this.metadata.tRNS_alpha, 0, n4);
            this.stream.skipBytes(n2 - n4);
        } else if (n3 == 0) {
            if (n2 != 2) {
                this.processWarningOccurred("tRNS chunk for gray image must have length 2, ignoring chunk.");
                this.stream.skipBytes(n2);
                return;
            }
            this.metadata.tRNS_gray = this.stream.readUnsignedShort();
            this.metadata.tRNS_colorType = 0;
        } else if (n3 == 2) {
            if (n2 != 6) {
                this.processWarningOccurred("tRNS chunk for RGB image must have length 6, ignoring chunk.");
                this.stream.skipBytes(n2);
                return;
            }
            this.metadata.tRNS_red = this.stream.readUnsignedShort();
            this.metadata.tRNS_green = this.stream.readUnsignedShort();
            this.metadata.tRNS_blue = this.stream.readUnsignedShort();
            this.metadata.tRNS_colorType = 2;
        } else {
            this.processWarningOccurred("Gray+Alpha and RGBS images may not have a tRNS chunk, ignoring it.");
            return;
        }
        this.metadata.tRNS_present = true;
    }

    private void parse_zTXt_chunk(int n2) throws IOException {
        String string = this.readNullTerminatedString();
        this.metadata.zTXt_keyword.add(string);
        int n3 = this.stream.readUnsignedByte();
        this.metadata.zTXt_compressionMethod.add(new Integer(n3));
        byte[] byArray = new byte[n2 - string.length() - 2];
        this.stream.readFully(byArray);
        this.metadata.zTXt_text.add(PNGImageReader.inflate(byArray));
    }

    private void updateImageProgress(int n2) {
        this.pixelsDone += n2;
        this.processImageProgress(100.0f * (float)this.pixelsDone / (float)this.totalPixels);
    }

    private void skipPass(int n2, int n3) throws IOException, IIOException {
        if (n2 == 0 || n3 == 0) {
            return;
        }
        int n4 = inputBandsForColorType[this.metadata.IHDR_colorType];
        int n5 = (n4 * n2 * this.metadata.IHDR_bitDepth + 7) / 8;
        byte[] byArray = new byte[n5];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = this.pixelStream.read();
            this.pixelStream.readFully(byArray, 0, n5);
            if (!this.abortRequested()) continue;
            return;
        }
    }

    private static int paethPredictor(int n2, int n3, int n4) {
        int n5 = n2 + n3 - n4;
        int n6 = Math.abs(n5 - n2);
        int n7 = Math.abs(n5 - n3);
        int n8 = Math.abs(n5 - n4);
        if (n6 <= n7 && n6 <= n8) {
            return n2;
        }
        if (n7 <= n8) {
            return n3;
        }
        return n4;
    }

    private void decodePass(int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IOException {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        if (n7 == 0 || n8 == 0) {
            return;
        }
        WritableRaster writableRaster = this.theImage.getWritableTile(0, 0);
        int n15 = writableRaster.getMinX();
        int n16 = n15 + writableRaster.getWidth() - 1;
        int n17 = writableRaster.getMinY();
        int n18 = n17 + writableRaster.getHeight() - 1;
        int[] nArray = PNGImageReader.computeUpdatedPixels(this.sourceRegion, this.destinationOffset, n15, n17, n16, n18, this.sourceXSubsampling, this.sourceYSubsampling, n3, n4, n7, n8, n5, n6);
        int n19 = nArray[0];
        int n20 = nArray[1];
        int n21 = nArray[2];
        int n22 = nArray[4];
        int n23 = nArray[5];
        int n24 = this.metadata.IHDR_bitDepth;
        int n25 = inputBandsForColorType[this.metadata.IHDR_colorType];
        int n26 = n24 == 16 ? 2 : 1;
        n26 *= n25;
        int n27 = (n25 * n7 * n24 + 7) / 8;
        int n28 = n14 = n24 == 16 ? n27 / 2 : n27;
        if (n21 == 0) {
            for (int i2 = 0; i2 < n8; ++i2) {
                this.updateImageProgress(n7);
                this.pixelStream.skipBytes(1 + n27);
            }
            return;
        }
        int n29 = (n19 - this.destinationOffset.x) * this.sourceXSubsampling + this.sourceRegion.x;
        int n30 = (n29 - n3) / n5;
        int n31 = n22 * this.sourceXSubsampling / n5;
        byte[] byArray = null;
        short[] sArray = null;
        byte[] byArray2 = new byte[n27];
        byte[] byArray3 = new byte[n27];
        WritableRaster writableRaster2 = this.createRaster(n7, 1, n25, n14, n24);
        int[] nArray2 = writableRaster2.getPixel(0, 0, (int[])null);
        DataBuffer dataBuffer = writableRaster2.getDataBuffer();
        int n32 = dataBuffer.getDataType();
        if (n32 == 0) {
            byArray = ((DataBufferByte)dataBuffer).getData();
        } else {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        }
        this.processPassStarted(this.theImage, n2, this.sourceMinProgressivePass, this.sourceMaxProgressivePass, n19, n20, n22, n23, this.destinationBands);
        if (this.sourceBands != null) {
            writableRaster2 = writableRaster2.createWritableChild(0, 0, writableRaster2.getWidth(), 1, 0, 0, this.sourceBands);
        }
        if (this.destinationBands != null) {
            writableRaster = writableRaster.createWritableChild(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, this.destinationBands);
        }
        boolean bl2 = false;
        int[] nArray3 = writableRaster.getSampleModel().getSampleSize();
        int n33 = nArray3.length;
        for (int i3 = 0; i3 < n33; ++i3) {
            if (nArray3[i3] == n24) continue;
            bl2 = true;
            break;
        }
        Object object = null;
        if (bl2) {
            n13 = (1 << n24) - 1;
            n12 = n13 / 2;
            object = new int[n33][];
            for (n11 = 0; n11 < n33; ++n11) {
                n10 = (1 << nArray3[n11]) - 1;
                object[n11] = new int[n13 + 1];
                for (n9 = 0; n9 <= n13; ++n9) {
                    object[n11][n9] = (n9 * n10 + n12) / n13;
                }
            }
        }
        int n34 = n13 = n31 == 1 && n22 == 1 && !bl2 ? 1 : 0;
        if (n13 != 0) {
            writableRaster2 = writableRaster2.createWritableChild(n30, 0, n21, 1, 0, 0, null);
        }
        for (n12 = 0; n12 < n8; ++n12) {
            this.updateImageProgress(n7);
            n11 = this.pixelStream.read();
            byte[] byArray4 = byArray3;
            byArray3 = byArray2;
            byArray2 = byArray4;
            this.pixelStream.readFully(byArray2, 0, n27);
            switch (n11) {
                case 0: {
                    break;
                }
                case 1: {
                    PNGImageReader.decodeSubFilter(byArray2, 0, n27, n26);
                    break;
                }
                case 2: {
                    PNGImageReader.decodeUpFilter(byArray2, 0, byArray3, 0, n27);
                    break;
                }
                case 3: {
                    PNGImageReader.decodeAverageFilter(byArray2, 0, byArray3, 0, n27, n26);
                    break;
                }
                case 4: {
                    PNGImageReader.decodePaethFilter(byArray2, 0, byArray3, 0, n27, n26);
                    break;
                }
                default: {
                    throw new IIOException("Unknown row filter type (= " + n11 + ")!");
                }
            }
            if (n24 < 16) {
                System.arraycopy(byArray2, 0, byArray, 0, n27);
            } else {
                int n35 = 0;
                for (n9 = 0; n9 < n14; ++n9) {
                    sArray[n9] = (short)(byArray2[n35] << 8 | byArray2[n35 + 1] & 0xFF);
                    n35 += 2;
                }
            }
            n10 = n12 * n6 + n4;
            if (n10 < this.sourceRegion.y || n10 >= this.sourceRegion.y + this.sourceRegion.height || (n10 - this.sourceRegion.y) % this.sourceYSubsampling != 0 || (n9 = this.destinationOffset.y + (n10 - this.sourceRegion.y) / this.sourceYSubsampling) < n17) continue;
            if (n9 > n18) break;
            if (n13 != 0) {
                writableRaster.setRect(n19, n9, writableRaster2);
            } else {
                int n36 = n30;
                for (int i4 = n19; i4 < n19 + n21; i4 += n22) {
                    writableRaster2.getPixel(n36, 0, nArray2);
                    if (bl2) {
                        for (int i5 = 0; i5 < n33; ++i5) {
                            nArray2[i5] = object[i5][nArray2[i5]];
                        }
                    }
                    writableRaster.setPixel(i4, n9, nArray2);
                    n36 += n31;
                }
            }
            this.processImageUpdate(this.theImage, n19, n9, n21, 1, n22, n23, this.destinationBands);
            if (!this.abortRequested()) continue;
            return;
        }
        this.processPassComplete(this.theImage);
    }

    private static void computeUpdatedPixels(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray, int n11) {
        boolean bl2 = false;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        for (int i2 = 0; i2 < n9; ++i2) {
            int n15 = n8 + i2 * n10;
            if (n15 < n2 || (n15 - n2) % n7 != 0) continue;
            if (n15 >= n2 + n3) break;
            int n16 = n4 + (n15 - n2) / n7;
            if (n16 < n5) continue;
            if (n16 > n6) break;
            if (!bl2) {
                n12 = n16;
                bl2 = true;
            } else if (n13 == -1) {
                n13 = n16;
            }
            n14 = n16;
        }
        nArray[n11] = n12;
        nArray[n11 + 2] = !bl2 ? 0 : n14 - n12 + 1;
        nArray[n11 + 4] = Math.max(n13 - n12, 1);
    }

    public int getNumImages(boolean bl2) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("No input source set!");
        }
        if (this.seekForwardOnly && bl2) {
            throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
        }
        return 1;
    }

    private static void decodeSubFilter(byte[] byArray, int n2, int n3, int n4) {
        for (int i2 = n4; i2 < n3; ++i2) {
            int n5 = byArray[i2 + n2] & 0xFF;
            byArray[i2 + n2] = (byte)(n5 += byArray[i2 + n2 - n4] & 0xFF);
        }
    }

    private static void decodeUpFilter(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = byArray[i2 + n2] & 0xFF;
            int n6 = byArray2[i2 + n3] & 0xFF;
            byArray[i2 + n2] = (byte)(n5 + n6);
        }
    }

    private static void decodeAverageFilter(byte[] byArray, int n2, byte[] byArray2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        for (n8 = 0; n8 < n5; ++n8) {
            n7 = byArray[n8 + n2] & 0xFF;
            n6 = byArray2[n8 + n3] & 0xFF;
            byArray[n8 + n2] = (byte)(n7 + n6 / 2);
        }
        for (n8 = n5; n8 < n4; ++n8) {
            n7 = byArray[n8 + n2] & 0xFF;
            int n9 = byArray[n8 + n2 - n5] & 0xFF;
            n6 = byArray2[n8 + n3] & 0xFF;
            byArray[n8 + n2] = (byte)(n7 + (n9 + n6) / 2);
        }
    }

    private static void decodePaethFilter(byte[] byArray, int n2, byte[] byArray2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        for (n8 = 0; n8 < n5; ++n8) {
            n7 = byArray[n8 + n2] & 0xFF;
            n6 = byArray2[n8 + n3] & 0xFF;
            byArray[n8 + n2] = (byte)(n7 + n6);
        }
        for (n8 = n5; n8 < n4; ++n8) {
            n7 = byArray[n8 + n2] & 0xFF;
            int n9 = byArray[n8 + n2 - n5] & 0xFF;
            n6 = byArray2[n8 + n3] & 0xFF;
            int n10 = byArray2[n8 + n3 - n5] & 0xFF;
            byArray[n8 + n2] = (byte)(n7 + PNGImageReader.paethPredictor(n9, n6, n10));
        }
    }

    private WritableRaster createRaster(int n2, int n3, int n4, int n5, int n6) {
        WritableRaster writableRaster = null;
        Point point = new Point(0, 0);
        if (n6 < 8 && n4 == 1) {
            DataBufferByte dataBufferByte = new DataBufferByte(n3 * n5);
            writableRaster = Raster.createPackedRaster(dataBufferByte, n2, n3, n6, point);
        } else if (n6 <= 8) {
            DataBufferByte dataBufferByte = new DataBufferByte(n3 * n5);
            writableRaster = Raster.createInterleavedRaster(dataBufferByte, n2, n3, n5, n4, bandOffsets[n4], point);
        } else {
            DataBufferUShort dataBufferUShort = new DataBufferUShort(n3 * n5);
            writableRaster = Raster.createInterleavedRaster(dataBufferUShort, n2, n3, n5, n4, bandOffsets[n4], point);
        }
        return writableRaster;
    }

    public void setInput(Object object, boolean bl2, boolean bl3) {
        super.setInput(object, bl2, bl3);
        this.stream = (ImageInputStream)object;
        this.resetStreamSettings();
    }

    private String readNullTerminatedString() throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = this.stream.read()) != 0) {
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    static int chunkType(String string) {
        char c2 = string.charAt(0);
        char c3 = string.charAt(1);
        char c4 = string.charAt(2);
        char c5 = string.charAt(3);
        int n2 = c2 << 24 | c3 << 16 | c4 << 8 | c5;
        return n2;
    }

    private static String inflate(byte[] byArray) throws IOException {
        int n2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        StringBuffer stringBuffer = new StringBuffer(80);
        while ((n2 = ((InputStream)inflaterInputStream).read()) != -1) {
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public Iterator getImageTypes(int n2) throws IIOException {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
        this.readHeader();
        ArrayList arrayList = new ArrayList(1);
        int n3 = this.metadata.IHDR_bitDepth;
        int n4 = this.metadata.IHDR_colorType;
        int n5 = n3 <= 8 ? 0 : 1;
        switch (n4) {
            case 0: {
                arrayList.add(ImageTypeSpecifier.createGrayscale(n3, n5, false));
                break;
            }
            case 2: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray = new int[]{0, 1, 2};
                arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, n5, false, false));
                break;
            }
            case 3: {
                this.readMetadata();
                int n6 = 1 << n3;
                byte[] byArray = this.metadata.PLTE_red;
                byte[] byArray2 = this.metadata.PLTE_green;
                byte[] byArray3 = this.metadata.PLTE_blue;
                if (this.metadata.PLTE_red.length < n6) {
                    byArray = new byte[n6];
                    System.arraycopy(this.metadata.PLTE_red, 0, byArray, 0, this.metadata.PLTE_red.length);
                    Arrays.fill(byArray, this.metadata.PLTE_red.length, n6, this.metadata.PLTE_red[this.metadata.PLTE_red.length - 1]);
                    byArray2 = new byte[n6];
                    System.arraycopy(this.metadata.PLTE_green, 0, byArray2, 0, Math.min(this.metadata.PLTE_green.length, n6));
                    Arrays.fill(byArray2, this.metadata.PLTE_green.length, n6, this.metadata.PLTE_green[this.metadata.PLTE_green.length - 1]);
                    byArray3 = new byte[n6];
                    System.arraycopy(this.metadata.PLTE_blue, 0, byArray3, 0, Math.min(this.metadata.PLTE_blue.length, n6));
                    Arrays.fill(byArray3, this.metadata.PLTE_blue.length, n6, this.metadata.PLTE_blue[this.metadata.PLTE_blue.length - 1]);
                }
                byte[] byArray4 = null;
                if (this.metadata.tRNS_present && this.metadata.tRNS_alpha != null) {
                    if (this.metadata.tRNS_alpha.length == byArray.length) {
                        byArray4 = this.metadata.tRNS_alpha;
                    } else {
                        byArray4 = new byte[byArray.length];
                        System.arraycopy(this.metadata.tRNS_alpha, 0, byArray4, 0, Math.min(this.metadata.tRNS_alpha.length, byArray.length));
                        Arrays.fill(byArray4, this.metadata.tRNS_alpha.length, byArray.length, (byte)-1);
                    }
                }
                arrayList.add(ImageTypeSpecifier.createIndexed(byArray, byArray2, byArray3, byArray4, n3, 0));
                break;
            }
            case 4: {
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                int[] nArray = new int[]{0, 1};
                arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, n5, true, false));
                break;
            }
            case 6: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray = new int[]{0, 1, 2, 3};
                arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, n5, true, false));
                break;
            }
        }
        return arrayList.iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    private void readImage(ImageReadParam imageReadParam) throws IIOException {
        this.readMetadata();
        int n2 = this.metadata.IHDR_width;
        int n3 = this.metadata.IHDR_height;
        this.sourceRegion = PNGImageReader.getSourceRegion(imageReadParam, n2, n3);
        this.sourceXSubsampling = 1;
        this.sourceYSubsampling = 1;
        this.sourceMinProgressivePass = 0;
        this.sourceMaxProgressivePass = 6;
        this.sourceBands = null;
        this.destinationBands = null;
        this.destinationOffset = new Point(0, 0);
        if (imageReadParam != null) {
            this.sourceXSubsampling = imageReadParam.getSourceXSubsampling();
            this.sourceYSubsampling = imageReadParam.getSourceYSubsampling();
            this.sourceMinProgressivePass = Math.max(imageReadParam.getSourceMinProgressivePass(), 0);
            this.sourceMaxProgressivePass = Math.min(imageReadParam.getSourceMaxProgressivePass(), 6);
            this.sourceBands = imageReadParam.getSourceBands();
            this.destinationBands = imageReadParam.getDestinationBands();
            this.destinationOffset = imageReadParam.getDestinationOffset();
        }
        try {
            this.stream.seek(this.imageStartPosition);
            PNGImageDataEnumeration pNGImageDataEnumeration = new PNGImageDataEnumeration(this.stream);
            InputStream inputStream = new SequenceInputStream(pNGImageDataEnumeration);
            inputStream = new InflaterInputStream(inputStream, new Inflater());
            inputStream = new BufferedInputStream(inputStream);
            this.pixelStream = new DataInputStream(inputStream);
            this.theImage = PNGImageReader.getDestination(imageReadParam, this.getImageTypes(0), n2, n3);
            int n4 = this.metadata.IHDR_colorType;
            PNGImageReader.checkReadParamBandSettings(imageReadParam, inputBandsForColorType[n4], this.theImage.getSampleModel().getNumBands());
            this.processImageStarted(0);
            this.decodeImage();
            if (this.abortRequested()) {
                this.processReadAborted();
            } else {
                this.processImageComplete();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IIOException("Error reading PNG image data", iOException);
        }
    }

    public IIOMetadata getStreamMetadata() throws IIOException {
        return null;
    }

    public IIOMetadata getImageMetadata(int n2) throws IIOException {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
        this.readMetadata();
        return this.metadata;
    }

    public PNGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    private static int[] computeUpdatedPixels(Rectangle rectangle, Point point, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        int[] nArray = new int[6];
        PNGImageReader.computeUpdatedPixels(rectangle.x, rectangle.width, point.x, n2, n4, n6, n8, n10, n12, nArray, 0);
        PNGImageReader.computeUpdatedPixels(rectangle.y, rectangle.height, point.y, n3, n5, n7, n9, n11, n13, nArray, 1);
        return nArray;
    }

    public BufferedImage read(int n2, ImageReadParam imageReadParam) throws IIOException {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
        this.readImage(imageReadParam);
        return this.theImage;
    }
}

