/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.com;

import sun.plugin.resources.ResourceHandler;

public class ParameterListCorrelator {
    private static final int BOOL_CODE = 0;
    private static final int BYTE_CODE = 1;
    private static final int SHORT_CODE = 2;
    private static final int INT_CODE = 3;
    private static final int LONG_CODE = 4;
    private static final int FLOAT_CODE = 5;
    private static final int DOUBLE_CODE = 6;
    private static final int CHAR_CODE = 7;
    private static final int NOT_PRIMITIVE_CODE = 8;
    private Class[] expectedClasses;
    private Object[] givenParameters;
    private boolean analysisIsDone;
    private boolean parametersCorrelateToClasses;
    private int numberOfConversionsNeeded;
    static Class class$java$lang$String;

    int numberOfConversionsNeeded() throws Exception {
        this.analyze();
        if (!this.parametersCorrelateToClasses) {
            throw new Exception(ResourceHandler.getMessage("com.method.argsTypeInvalid"));
        }
        return this.numberOfConversionsNeeded;
    }

    private void analyze() throws Exception {
        if (!this.analysisIsDone) {
            this.parametersCorrelateToClasses = true;
            if (this.expectedClasses.length != this.givenParameters.length) {
                this.reportParametersDoNotCorrelate();
            }
            for (int i = 0; !this.analysisIsDone && i < this.givenParameters.length; ++i) {
                this.analyzeParameter(this.expectedClasses[i], this.givenParameters[i]);
            }
            this.analysisIsDone = true;
        }
    }

    private void reportParametersDoNotCorrelate() {
        this.parametersCorrelateToClasses = false;
        this.analysisIsDone = true;
    }

    boolean parametersCorrelateToClasses() throws Exception {
        this.analyze();
        return this.parametersCorrelateToClasses;
    }

    private static int typeCodeFromTypeName(String string) {
        if (string.equals("boolean") || string.equals("java.lang.Boolean")) {
            return 0;
        }
        if (string.equals("byte") || string.equals("java.lang.Byte")) {
            return 1;
        }
        if (string.equals("short") || string.equals("java.lang.Short")) {
            return 2;
        }
        if (string.equals("int") || string.equals("java.lang.Integer")) {
            return 3;
        }
        if (string.equals("long") || string.equals("java.lang.Long")) {
            return 4;
        }
        if (string.equals("float") || string.equals("java.lang.Float")) {
            return 5;
        }
        if (string.equals("double") || string.equals("java.lang.Double")) {
            return 6;
        }
        if (string.equals("char") || string.equals("java.lang.Character")) {
            return 7;
        }
        return 8;
    }

    private void analyzeParameter(Class clazz, Class clazz2) throws Exception {
        if (clazz2 == null) {
            return;
        }
        if (clazz.equals(clazz2)) {
            return;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            ++this.numberOfConversionsNeeded;
        } else if (clazz == (class$java$lang$String == null ? (class$java$lang$String = ParameterListCorrelator.class$("java.lang.String")) : class$java$lang$String)) {
            ++this.numberOfConversionsNeeded;
        } else if (clazz.isArray()) {
            if (!clazz2.isArray()) {
                this.reportParametersDoNotCorrelate();
            } else {
                Class<?> clazz3 = clazz.getComponentType();
                Class<?> clazz4 = clazz2.getComponentType();
                this.analyzeParameter(clazz3, clazz4);
            }
        } else if (!this.typesAreEquivalentPrimitives(clazz, clazz2)) {
            this.reportParametersDoNotCorrelate();
        }
    }

    private boolean typesAreEquivalentPrimitives(Class clazz, Class clazz2) {
        int n = ParameterListCorrelator.typeCodeFromTypeName(clazz.getName());
        if (n != 8) {
            int n2 = ParameterListCorrelator.typeCodeFromTypeName(clazz2.getName());
            if (n2 == 8) {
                return false;
            }
            if (n != n2) {
                ++this.numberOfConversionsNeeded;
            }
            return true;
        }
        return false;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private void analyzeParameter(Class clazz, Object object) throws Exception {
        if (object != null) {
            this.analyzeParameter(clazz, object.getClass());
        }
    }

    ParameterListCorrelator(Class[] classArray, Object[] objectArray) {
        this.expectedClasses = classArray;
        if (this.expectedClasses == null) {
            this.expectedClasses = new Class[0];
        }
        this.givenParameters = objectArray;
        if (this.givenParameters == null) {
            this.givenParameters = new Object[0];
        }
        this.analysisIsDone = false;
        this.numberOfConversionsNeeded = 0;
        this.parametersCorrelateToClasses = false;
    }
}

