/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.net;

import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.net.CanceledDownloadException;
import com.sun.javaws.net.HttpDownload;
import com.sun.javaws.net.HttpDownloadListener;
import com.sun.javaws.net.HttpRequest;
import com.sun.javaws.net.HttpResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BasicDownloadLayer
implements HttpDownload {
    private static final int BUF_SIZE = 32768;
    private HttpRequest _httpRequest;

    public BasicDownloadLayer(HttpRequest httpRequest) {
        this._httpRequest = httpRequest;
    }

    public void download(HttpResponse httpResponse, File file, HttpDownloadListener httpDownloadListener, int n) throws CanceledDownloadException, IOException {
        int n2 = httpResponse.getContentLength();
        if (httpDownloadListener != null) {
            httpDownloadListener.downloadProgress(0, n2);
        }
        if (Globals.TraceDownload) {
            Debug.println("Doing download");
        }
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            bufferedInputStream = httpResponse.getInputStream();
            fileOutputStream = new FileOutputStream(file);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            byte[] byArray = new byte[32768];
            while ((n3 = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                if (!(n != 0 && n != 1 || n4 != 0 || DownloadProtocol.isJarHeaderValid(byArray))) {
                    throw new IOException("Invalid jar file");
                }
                ((OutputStream)fileOutputStream).write(byArray, 0, n3);
                if ((n5 += n3) > n2 && n2 != 0) {
                    n5 = n2;
                }
                if (httpDownloadListener != null) {
                    httpDownloadListener.downloadProgress(n5, n2);
                }
                ++n4;
            }
            if (Globals.TraceDownload) {
                Debug.println("Wrote URL " + httpResponse.getRequest() + " to file " + file);
            }
            ((InputStream)bufferedInputStream).close();
            bufferedInputStream = null;
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            if (Globals.TraceDownload) {
                Debug.println("Got exception while downloading resource: " + iOException);
            }
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
                bufferedInputStream = null;
            }
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
                fileOutputStream = null;
            }
            if (file != null) {
                file.delete();
            }
            throw iOException;
        }
        if (httpDownloadListener != null) {
            httpDownloadListener.downloadProgress(n2, n2);
        }
    }
}

