/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.general;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.SplashScreen;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.ui.general.WhenInstallPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class GeneralUtilities {
    private static ImageIcon _jawsTitleImage;
    private static ImageIcon _jawsTitleVerImage;
    private static ImageIcon _sunLogoImage;
    private static ImageIcon _javaCupImage;
    private static ImageIcon _dividerImage;
    private static ImageIcon _alertImage;
    private static ImageIcon _infoImage;
    private static ImageIcon _lockImage;
    private static ImageIcon _defaultImage;
    private static int _tileWidth;
    private static int _tileHeight;
    public static final int INSTALL_NO = 0;
    public static final int INSTALL_YES = 1;
    public static final int INSTALL_ASK = 2;

    public static void placeWindow(Window window) {
        Window window2 = window.getOwner();
        Rectangle rectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
        Rectangle rectangle2 = window.getBounds();
        Rectangle rectangle3 = window2 == null ? rectangle : window2.getBounds();
        double d = (double)rectangle3.height - (double)rectangle3.height / 1.618;
        rectangle2.x = rectangle3.x + (rectangle3.width - rectangle2.width) / 2;
        int n = (int)(d - (double)(rectangle2.height / 2));
        int n2 = window2 == null ? 0 : window2.getInsets().top;
        rectangle2.y = rectangle3.y + Math.max(n, n2);
        if (rectangle2.x + rectangle2.width > rectangle.width) {
            rectangle2.x = Math.max(rectangle.width - rectangle2.width, 0);
        }
        if (rectangle2.y + rectangle2.height > rectangle.height) {
            rectangle2.y = Math.max(rectangle.height - rectangle2.height, 0);
        }
        window.setBounds(rectangle2);
    }

    private static void invokeOnEventDispatchingThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static ImageIcon getDefaultImage() {
        if (_defaultImage == null) {
            _defaultImage = Resources.getIconFromFilename("resources/JavaIcon-48.png");
        }
        return _defaultImage;
    }

    public static ImageIcon getDividerImage() {
        if (_dividerImage == null) {
            _dividerImage = Resources.getIcon("divider.image");
        }
        return _dividerImage;
    }

    public static ImageIcon getInfoIcon() {
        if (_infoImage == null) {
            _infoImage = Resources.getIcon("info.image");
        }
        return _infoImage;
    }

    public static ImageIcon getJavaCupImage() {
        if (_javaCupImage == null) {
            _javaCupImage = Resources.getIconFromFilename("resources/JavaIcon47x88.png");
        }
        return _javaCupImage;
    }

    public static ImageIcon getJawsTitleImage() {
        if (_jawsTitleImage == null) {
            _jawsTitleImage = Resources.getIcon("jawsTitle.image");
        }
        return _jawsTitleImage;
    }

    public static ImageIcon getLockIcon() {
        if (_lockImage == null) {
            _lockImage = Resources.getIcon("lock.image");
        }
        return _lockImage;
    }

    public static ImageIcon getSunLogoImage() {
        if (_sunLogoImage == null) {
            _sunLogoImage = Resources.getIcon("sunLogo.image");
        }
        return _sunLogoImage;
    }

    public static ImageIcon getWarningIcon() {
        if (_alertImage == null) {
            _alertImage = Resources.getIcon("alert.image");
        }
        return _alertImage;
    }

    static void access$100(JButton jButton) {
        GeneralUtilities.setReturn(jButton);
    }

    private static void setReturn(JButton jButton) {
        Container container = jButton;
        while (container != null) {
            if (!((container = container.getParent()) instanceof JOptionPane)) continue;
            ((JOptionPane)container).setValue(jButton);
            break;
        }
    }

    private static Object messageFormat(Object object) {
        if (object instanceof String) {
            return new PlainTextArea((String)object);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = objectArray[n] instanceof String ? new PlainTextArea((String)objectArray[n]) : objectArray[n];
                ++n;
            }
            return objectArray2;
        }
        return object;
    }

    public static void showAboutDialog(Frame frame, String string) {
        String string2 = "     Copyright \u00a9 2008 Sun Microsystems, Inc.  All rights reserved.  Use is subject to license terms.  Third-party software, including font technology, is copyrighted and licensed from Sun suppliers.  Sun,  Sun Microsystems,  the Sun logo and  Java are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S. and other countries.  All SPARC trademarks are used under license and are trademarks or registered trademarks of SPARC International, Inc. in the U.S. and other countries.  Federal Acquisitions: Commercial Software - Government Users Subject to Standard License Terms and Conditions.  ";
        String string3 = "\n\n";
        String string4 = "     Copyright \u00a9 2008 Sun Microsystems, Inc. Tous droits r\u00e9serv\u00e9s.  Distribu\u00e9 par des licences qui en restreignent l'utilisation.  Le logiciel d\u00e9tenu par des tiers, et qui comprend la technologie relative aux polices de caract\u00e8res, est prot\u00e9g\u00e9 par un copyright et licenci\u00e9 par des fournisseurs de Sun.  Sun,  Sun Microsystems,  le logo Sun et  Java sont des marques de fabrique ou des marques d\u00e9pos\u00e9es de Sun Microsystems, Inc. aux Etats-Unis et dans d'autres pays.  Toutes les marques SPARC sont utilis\u00e9es sous licence et sont des marques de fabrique ou des marques d\u00e9pos\u00e9es de SPARC International, Inc. aux Etats-Unis et dans d'autres pays.  ";
        JDialog jDialog = new JDialog(frame, string, true);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 31);
        jTextArea.setText(string2 + string3 + string4);
        jTextArea.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JButton jButton = new JButton(Resources.getString("aboutBox.closeButton"));
        jPanel2.add((Component)jButton, "South");
        jPanel.add((Component)jPanel2, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        JLabel jLabel = new JLabel(GeneralUtilities.getSunLogoImage());
        jLabel.setBorder(border);
        jPanel3.add((Component)jLabel, "West");
        JLabel jLabel2 = new JLabel(GeneralUtilities.getJavaCupImage());
        jLabel2.setBorder(border);
        jPanel3.add((Component)jLabel2, "East");
        jPanel.add((Component)jPanel3, "West");
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 2, 6, 2));
        jDialog.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(jDialog){
            private final JDialog val$dialog;

            public void actionPerformed(ActionEvent actionEvent) {
                this.val$dialog.dispose();
            }
            {
                this.val$dialog = jDialog;
            }
        });
        jButton.requestFocus();
        jDialog.getRootPane().setDefaultButton(jButton);
        JLabel jLabel3 = new JLabel(Resources.getString("aboutBox.versionLabel", Globals.getBuildID()), 2);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        container.add((Component)jLabel3, "North");
        container.add((Component)jScrollPane, "Center");
        container.add((Component)jPanel, "South");
        jDialog.setBounds(0, 0, 400, 400);
        GeneralUtilities.placeWindow(jDialog);
        jDialog.addWindowListener(new WindowAdapter(jScrollPane){
            private final JScrollPane val$sp;

            public void windowOpened(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final 3 this$0;

                    public void run() {
                        3.access$000(this.this$0).getViewport().setViewPosition(new Point(0, 0));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.val$sp = jScrollPane;
            }

            static JScrollPane access$000(3 var0) {
                return var0.val$sp;
            }
        });
        jDialog.show();
    }

    public static int showLocalInstallDialog(Window window, String string) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new JButton[4];
        objectArray2[0] = new JButton(Resources.getString("install.yesButton"));
        objectArray2[0].setMnemonic(Resources.getVKCode("install.yesMnemonic"));
        JButton jButton = objectArray2[0];
        objectArray2[1] = new JButton(Resources.getString("install.noButton"));
        objectArray2[1].setMnemonic(Resources.getVKCode("install.noMnemonic"));
        JButton jButton2 = objectArray2[1];
        objectArray2[2] = new JButton(Resources.getString("install.askButton"));
        objectArray2[2].setMnemonic(Resources.getVKCode("install.askMnemonic"));
        objectArray2[3] = new JButton(Resources.getString("install.configButton"));
        objectArray2[3].setMnemonic(Resources.getVKCode("install.configMnemonic"));
        int n = 0;
        while (n < 3) {
            objectArray2[n].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GeneralUtilities.access$100((JButton)actionEvent.getSource());
                }
            });
            ++n;
        }
        objectArray2[3].addActionListener(new ActionListener(jButton, jButton2){
            private final JButton val$yesButton;
            private final JButton val$noButton;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                WhenInstallPanel whenInstallPanel = new WhenInstallPanel();
                String string = Resources.getString("install.configureTitle");
                Component component = (Component)actionEvent.getSource();
                while (component != null && !(component instanceof JDialog)) {
                    component = component.getParent();
                }
                int n = GeneralUtilities.access$200(component, whenInstallPanel, string, 2, -1, null, null, false, null);
                switch (n) {
                    case 0: {
                        ConfigProperties configProperties = ConfigProperties.getInstance();
                        int n2 = whenInstallPanel.getWhen();
                        if (n2 == 1) {
                            configProperties.setWhenInstall(n2);
                            GeneralUtilities.access$100(this.val$yesButton);
                        } else if (n2 == 0) {
                            configProperties.setWhenInstall(n2);
                            GeneralUtilities.access$100(this.val$noButton);
                        } else {
                            configProperties.setWhenInstall(2);
                        }
                        ConfigProperties configProperties2 = configProperties;
                        synchronized (configProperties2) {
                            configProperties.store();
                            break;
                        }
                    }
                }
            }
            {
                this.val$yesButton = jButton;
                this.val$noButton = jButton2;
            }
        });
        String string2 = Resources.getString("install.installTitle", string);
        objectArray[0] = Resources.getString("install.message0");
        objectArray[1] = Resources.getString("install.message1", string);
        int n2 = GeneralUtilities.showOptionDialog(window, objectArray, string2, -1, -1, objectArray2, objectArray2[2], true, null);
        switch (n2) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return 2;
    }

    public static JFrame createFrame(String string) {
        return new JFrame(string);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n) {
        GeneralUtilities.showOptionDialog(component, object, string, -1, n);
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2) {
        return GeneralUtilities.showOptionDialog(component, object, string, n, n2, null, null);
    }

    public static JDialog createDialog(Frame frame, String string, boolean bl) {
        return new JDialog(frame, string, bl);
    }

    private static JFrame getFrameOwner(Component component, String string) {
        if (component != null || !Globals.isWindowsPlatform()) {
            return null;
        }
        JFrame jFrame = new JFrame(string);
        jFrame.setLocation(-200, -200);
        return jFrame;
    }

    public static JTextPane addBoldText(JTextPane jTextPane, String string, Object[] objectArray) {
        int n;
        MessageFormat messageFormat = new MessageFormat("");
        int n2 = 0;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
        if (jTextPane == null) {
            jTextPane = new JTextPane(){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.width = Math.min(400, dimension.width);
                    return dimension;
                }
            };
        }
        Document document = jTextPane.getDocument();
        StyleConstants.setBold(simpleAttributeSet, true);
        StyleConstants.setFontFamily(simpleAttributeSet, "SansSerif");
        StyleConstants.setFontFamily(simpleAttributeSet2, "SansSerif");
        while ((n = string.indexOf("{", n2)) != -1) {
            if (n != 0 && (n <= 0 || string.charAt(n - 1) == '\'')) continue;
            if (n2 != n) {
                try {
                    document.insertString(document.getLength(), string.substring(n2, n), simpleAttributeSet2);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            int n3 = string.indexOf("}", n) + 1;
            messageFormat.applyPattern(string.substring(n, n3));
            try {
                document.insertString(document.getLength(), messageFormat.format(objectArray), simpleAttributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            n2 = n3;
        }
        if (n2 < string.length()) {
            try {
                document.insertString(document.getLength(), string.substring(n2), simpleAttributeSet2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        jTextPane.setOpaque(false);
        jTextPane.setEditable(false);
        return jTextPane;
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Object[] objectArray, Object object2) {
        return GeneralUtilities.showOptionDialog(component, object, string, n, n2, objectArray, object2, false, null);
    }

    public static String showInputDialog(Component component, Object object, String string, String string2) {
        Object object2 = GeneralUtilities.messageFormat(object);
        if (object2 instanceof PlainTextArea) {
            ((PlainTextArea)object2).setRows(2);
        }
        return (String)JOptionPane.showInputDialog(component, object2, string, -1, GeneralUtilities.getDefaultImage(), null, string2);
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Object[] objectArray, Object object2, Icon icon) {
        return GeneralUtilities.showOptionDialog(component, object, string, n, n2, objectArray, object2, false, icon);
    }

    static int access$200(Component component, Object object, String string, int n, int n2, Object[] objectArray, Object object2, boolean bl, Icon icon) {
        return GeneralUtilities.showOptionDialog(component, object, string, n, n2, objectArray, object2, bl, icon);
    }

    private static int showOptionDialog(Component component, Object object, String string, int n, int n2, Object[] objectArray, Object object2, boolean bl, Icon icon) {
        Object object3;
        if (icon == null) {
            icon = GeneralUtilities.getDefaultImage();
        }
        JOptionPane jOptionPane = new JOptionPane(GeneralUtilities.messageFormat(object), n2, n, icon, objectArray, object2);
        JFrame jFrame = GeneralUtilities.getFrameOwner(component, string);
        JDialog jDialog = jOptionPane.createDialog(jFrame != null ? jFrame : component, string);
        jOptionPane.selectInitialValue();
        GeneralUtilities.invokeOnEventDispatchingThread(new Runnable(jDialog){
            private final JDialog val$dialog;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Container container = this.val$dialog.getContentPane();
                Graphics graphics = container.getGraphics();
                try {
                    graphics.setClip(new Rectangle(0, 0, container.getWidth(), container.getHeight()));
                    container.paint(graphics);
                    Object var4_3 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    graphics.dispose();
                    throw throwable;
                }
                this.val$dialog.validate();
                this.val$dialog.setSize(this.val$dialog.getPreferredSize());
            }
            {
                this.val$dialog = jDialog;
            }
        });
        SplashScreen.hide();
        if (jFrame != null) {
            jFrame.setVisible(true);
        }
        jDialog.show();
        if (jFrame != null) {
            jFrame.setVisible(false);
            jFrame.dispose();
        }
        if ((object3 = jOptionPane.getValue()) == null) {
            return -1;
        }
        if (objectArray == null) {
            if (object3 instanceof Integer) {
                return (Integer)object3;
            }
            return -1;
        }
        int n3 = 0;
        int n4 = objectArray.length;
        while (n3 < n4) {
            if (objectArray[n3].equals(object3)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static class PlainTextArea
    extends JTextArea {
        public boolean isFocusTraversable() {
            return false;
        }

        PlainTextArea(String string) {
            super(string);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setOpaque(false);
            this.setEditable(false);
        }
    }
}

