/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Vector;
import org.hsql.Cache;
import org.hsql.Channel;
import org.hsql.Column;
import org.hsql.Constraint;
import org.hsql.Database;
import org.hsql.Index;
import org.hsql.Log;
import org.hsql.Node;
import org.hsql.Record;
import org.hsql.Result;
import org.hsql.Row;
import org.hsql.Trace;

class Table {
    private String sName;
    private Vector vColumn;
    private Vector vIndex;
    private int iVisibleColumns;
    private int iColumnCount;
    private int iPrimaryKey;
    private boolean bCached;
    private Database dDatabase;
    private Log lLog;
    private int iIndexCount;
    private int iIdentityColumn;
    private int iIdentityId;
    private Vector vConstraint;
    private int iConstraintCount;
    Cache cCache;

    void addConstraint(Constraint constraint) {
        this.vConstraint.addElement(constraint);
        ++this.iConstraintCount;
    }

    Vector getConstraints() {
        return this.vConstraint;
    }

    void addColumn(String string, int n) throws SQLException {
        this.addColumn(string, n, true, false);
    }

    void addColumn(Column column) throws SQLException {
        this.addColumn(column.sName, column.iType, column.isNullable(), column.isIdentity());
    }

    void addColumn(String string, int n, boolean bl, boolean bl2) throws SQLException {
        if (bl2) {
            Trace.check(n == 4, 15, string);
            Trace.check(this.iIdentityColumn == -1, 23, string);
            this.iIdentityColumn = this.iColumnCount;
        }
        Trace.assert(this.iPrimaryKey == -1, "Table.addColumn");
        this.vColumn.addElement(new Column(string, bl, n, bl2));
        ++this.iColumnCount;
    }

    void addColumns(Result result) throws SQLException {
        int n = 0;
        while (n < result.getColumnCount()) {
            this.addColumn(result.sLabel[n], result.iType[n], true, false);
            ++n;
        }
    }

    String getName() {
        return this.sName;
    }

    int getInternalColumnCount() {
        return this.iColumnCount;
    }

    Table moveDefinition(String string) throws SQLException {
        Table table = new Table(this.dDatabase, true, this.getName(), this.isCached());
        int n = 0;
        while (n < this.getColumnCount()) {
            table.addColumn(this.getColumn(n));
            ++n;
        }
        if (this.iVisibleColumns < this.iColumnCount) {
            table.createPrimaryKey();
        } else {
            table.createPrimaryKey(this.getPrimaryIndex().getColumns()[0]);
        }
        Index index = null;
        while ((index = this.getNextIndex(index)) != null) {
            if (string != null && index.getName().equals(string) || index == this.getPrimaryIndex()) continue;
            table.createIndex(index);
        }
        int n2 = 0;
        while (n2 < this.iConstraintCount) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(n2);
            constraint.replaceTable(this, table);
            ++n2;
        }
        table.vConstraint = this.vConstraint;
        return table;
    }

    int getColumnCount() {
        return this.iVisibleColumns;
    }

    int getIndexCount() {
        return this.iIndexCount;
    }

    int getIdentityColumn() {
        return this.iIdentityColumn;
    }

    int getColumnNr(String string) throws SQLException {
        int n = this.searchColumn(string);
        if (n == -1) {
            throw Trace.error(27, string);
        }
        return n;
    }

    int searchColumn(String string) {
        int n = 0;
        while (n < this.iColumnCount) {
            if (string.equals(((Column)this.vColumn.elementAt((int)n)).sName)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    String getColumnName(int n) {
        return this.getColumn((int)n).sName;
    }

    int getColumnType(int n) {
        return this.getColumn((int)n).iType;
    }

    boolean getColumnIsNullable(int n) {
        return this.getColumn(n).isNullable();
    }

    Index getPrimaryIndex() throws SQLException {
        if (this.iPrimaryKey == -1) {
            return null;
        }
        return this.getIndex(0);
    }

    Index getIndexForColumn(int n) throws SQLException {
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            Index index = this.getIndex(n2);
            if (index.getColumns()[0] == n) {
                return index;
            }
            ++n2;
        }
        return null;
    }

    Index getIndexForColumns(int[] nArray) throws SQLException {
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            int[] nArray2 = index.getColumns();
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n2 >= nArray2.length || nArray2[n2] != nArray[n2]) break;
                ++n2;
            }
            if (n2 == nArray.length) {
                return index;
            }
            ++n;
        }
        return null;
    }

    String getIndexRoots() throws SQLException {
        Trace.assert(this.bCached, "Table.getIndexRootData");
        String string = "";
        int n = 0;
        while (n < this.iIndexCount) {
            Node node = this.getIndex(n).getRoot();
            string = node != null ? string + node.getKey() + " " : string + "-1 ";
            ++n;
        }
        string = string + this.iIdentityId;
        return string;
    }

    void setIndexRoots(String string) throws SQLException {
        Trace.check(this.bCached, 21);
        int n = 0;
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            int n3 = string.indexOf(32, n);
            int n4 = Integer.parseInt(string.substring(n, n3));
            if (n4 != -1) {
                Row row = this.cCache.getRow(n4, this);
                Node node = row.getNode(n2);
                this.getIndex(n2).setRoot(node);
            }
            n = n3 + 1;
            ++n2;
        }
        this.iIdentityId = Integer.parseInt(string.substring(n));
    }

    Index getNextIndex(Index index) {
        int n = 0;
        if (index != null) {
            while (n < this.iIndexCount && this.getIndex(n) != index) {
                ++n;
            }
            ++n;
        }
        if (n < this.iIndexCount) {
            return this.getIndex(n);
        }
        return null;
    }

    int getType(int n) {
        return this.getColumn((int)n).iType;
    }

    void createPrimaryKey(int n) throws SQLException {
        Trace.assert(this.iPrimaryKey == -1, "Table.createPrimaryKey(column)");
        this.iVisibleColumns = this.iColumnCount;
        this.iPrimaryKey = n;
        int[] nArray = new int[]{n};
        this.createIndex(nArray, "SYSTEM_PK", true);
    }

    void createPrimaryKey() throws SQLException {
        Trace.assert(this.iPrimaryKey == -1, "Table.createPrimaryKey");
        this.addColumn("SYSTEM_ID", 4, true, true);
        this.createPrimaryKey(this.iColumnCount - 1);
        this.iVisibleColumns = this.iColumnCount - 1;
    }

    void createIndex(Index index) throws SQLException {
        this.createIndex(index.getColumns(), index.getName(), index.isUnique());
    }

    void createIndex(int[] nArray, String string, boolean bl) throws SQLException {
        Object object;
        Trace.assert(this.iPrimaryKey != -1, "createIndex");
        int n = 0;
        while (n < this.iIndexCount) {
            object = this.getIndex(n);
            if (string.equals(((Index)object).getName())) {
                throw Trace.error(22);
            }
            ++n;
        }
        n = nArray.length;
        object = new int[bl ? n : n + 1];
        int[] nArray2 = new int[bl ? n : n + 1];
        int n2 = 0;
        while (n2 < n) {
            object[n2] = nArray[n2];
            nArray2[n2] = this.getColumn((int)object[n2]).iType;
            ++n2;
        }
        if (!bl) {
            object[n] = this.iPrimaryKey;
            nArray2[n] = this.getColumn((int)this.iPrimaryKey).iType;
        }
        Index index = new Index(string, (int[])object, nArray2, bl);
        if (this.iIndexCount != 0) {
            Trace.assert(this.isEmpty(), "createIndex");
        }
        this.vIndex.addElement(index);
        ++this.iIndexCount;
    }

    void checkDropIndex(String string) throws SQLException {
        int n = 0;
        while (n < this.iIndexCount) {
            if (string.equals(this.getIndex(n).getName())) {
                Trace.check(n != 0, 24);
                return;
            }
            ++n;
        }
        throw Trace.error(25, string);
    }

    boolean isEmpty() {
        return this.getIndex(0).getRoot() == null;
    }

    Object[] getNewRow() {
        return new Object[this.iColumnCount];
    }

    void moveData(Table table) throws SQLException {
        Object[] objectArray;
        Index index = table.getPrimaryIndex();
        Node node = index.first();
        while (node != null) {
            objectArray = node.getData();
            this.insertNoCheck(objectArray, null);
            node = index.next(node);
        }
        index = this.getPrimaryIndex();
        node = index.first();
        while (node != null) {
            objectArray = node.getData();
            table.deleteNoCheck(objectArray, null);
            node = index.next(node);
        }
    }

    void checkUpdate(int[] nArray, Result result, Result result2) throws SQLException {
        if (this.dDatabase.isReferentialIntegrity()) {
            int n = 0;
            while (n < this.iConstraintCount) {
                Constraint constraint = (Constraint)this.vConstraint.elementAt(n);
                constraint.checkUpdate(nArray, result, result2);
                ++n;
            }
        }
    }

    void insert(Result result, Channel channel) throws SQLException {
        Record record = result.rRoot;
        int n = result.getColumnCount();
        while (record != null) {
            Object[] objectArray = this.getNewRow();
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = record.data[n2];
                ++n2;
            }
            this.insert(objectArray, channel);
            record = record.next;
        }
    }

    void insert(Object[] objectArray, Channel channel) throws SQLException {
        if (this.dDatabase.isReferentialIntegrity()) {
            int n = 0;
            while (n < this.iConstraintCount) {
                ((Constraint)this.vConstraint.elementAt(n)).checkInsert(objectArray);
                ++n;
            }
        }
        this.insertNoCheck(objectArray, channel);
    }

    /*
     * Unable to fully structure code
     */
    void insertNoCheck(Object[] var1_1, Channel var2_2) throws SQLException {
        block14: {
            if (this.iIdentityColumn != -1) {
                var3_3 = (Integer)var1_1[this.iIdentityColumn];
                if (var3_3 == null) {
                    if (var2_2 != null) {
                        var2_2.setLastIdentity(this.iIdentityId);
                    }
                    var1_1[this.iIdentityColumn] = new Integer(this.iIdentityId++);
                } else {
                    var4_5 = var3_3;
                    if (this.iIdentityId <= var4_5) {
                        if (var2_2 != null) {
                            var2_2.setLastIdentity(var4_5);
                        }
                        this.iIdentityId = var4_5 + 1;
                    }
                }
            }
            var3_4 = 0;
            while (var3_4 < this.iColumnCount) {
                if (var1_1[var3_4] == null && !this.getColumn(var3_4).isNullable()) {
                    throw Trace.error(9);
                }
                ++var3_4;
            }
            var3_4 = 0;
            try {
                var4_6 = new Row(this, var1_1);
                while (var3_4 < this.iIndexCount) {
                    var5_8 = var4_6.getNode(var3_4);
                    this.getIndex(var3_4).insert(var5_8);
                    ++var3_4;
                }
                break block14;
            }
            catch (SQLException var4_7) {
                --var3_4;
                ** while (var3_4 >= 0)
            }
lbl-1000:
            // 1 sources

            {
                this.getIndex(var3_4).delete(var1_1, var3_4 == 0);
                --var3_4;
                continue;
            }
lbl34:
            // 1 sources

            throw var4_7;
        }
        if (var2_2 != null) {
            var2_2.addTransactionInsert(this, var1_1);
        }
        if (this.lLog != null) {
            this.lLog.write(this.getInsertStatement(var1_1));
        }
    }

    void delete(Object[] objectArray, Channel channel) throws SQLException {
        if (this.dDatabase.isReferentialIntegrity()) {
            int n = 0;
            while (n < this.iConstraintCount) {
                ((Constraint)this.vConstraint.elementAt(n)).checkDelete(objectArray);
                ++n;
            }
        }
        this.deleteNoCheck(objectArray, channel);
    }

    void deleteNoCheck(Object[] objectArray, Channel channel) throws SQLException {
        int n = 1;
        while (n < this.iIndexCount) {
            this.getIndex(n).delete(objectArray, false);
            ++n;
        }
        this.getIndex(0).delete(objectArray, true);
        if (channel != null) {
            channel.addTransactionDelete(this, objectArray);
        }
        if (this.lLog != null) {
            this.lLog.write(this.getDeleteStatement(objectArray));
        }
    }

    String getInsertStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" VALUES(");
        int n = 0;
        while (n < this.iVisibleColumns) {
            stringBuffer.append(Column.createString(objectArray[n], this.getColumn((int)n).iType));
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        return stringBuffer.toString();
    }

    boolean isCached() {
        return this.bCached;
    }

    Index getIndex(String string) {
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            if (string.equals(index.getName())) {
                return index;
            }
            ++n;
        }
        return null;
    }

    Column getColumn(int n) {
        return (Column)this.vColumn.elementAt(n);
    }

    private Index getIndex(int n) {
        return (Index)this.vIndex.elementAt(n);
    }

    private String getDeleteStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
        stringBuffer.append(this.sName);
        stringBuffer.append(" WHERE ");
        if (this.iVisibleColumns < this.iColumnCount) {
            int n = 0;
            while (n < this.iVisibleColumns) {
                stringBuffer.append(this.getColumn((int)n).sName);
                stringBuffer.append('=');
                stringBuffer.append(Column.createString(objectArray[n], this.getColumn((int)n).iType));
                if (n < this.iVisibleColumns - 1) {
                    stringBuffer.append(" AND ");
                }
                ++n;
            }
        } else {
            stringBuffer.append(this.getColumn((int)this.iPrimaryKey).sName);
            stringBuffer.append("=");
            stringBuffer.append(Column.createString(objectArray[this.iPrimaryKey], this.getColumn((int)this.iPrimaryKey).iType));
        }
        return stringBuffer.toString();
    }

    Table(Database database, boolean bl, String string, boolean bl2) {
        this.dDatabase = database;
        Log log = this.lLog = bl ? database.getLog() : null;
        if (bl2) {
            this.cCache = this.lLog.cCache;
            this.bCached = true;
        }
        this.sName = string;
        this.iPrimaryKey = -1;
        this.iIdentityColumn = -1;
        this.vColumn = new Vector();
        this.vIndex = new Vector();
        this.vConstraint = new Vector();
    }
}

