/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Vector;
import org.hsql.Channel;
import org.hsql.Column;
import org.hsql.Database;
import org.hsql.Expression;
import org.hsql.Function;
import org.hsql.Record;
import org.hsql.Result;
import org.hsql.Select;
import org.hsql.Table;
import org.hsql.TableFilter;
import org.hsql.Tokenizer;
import org.hsql.Trace;

class Parser {
    private Database dDatabase;
    private Tokenizer tTokenizer;
    private Channel cChannel;
    private String sTable;
    private String sToken;
    private Object oData;
    private int iType;
    private int iToken;

    Result processSelect() throws SQLException {
        Select select = this.parseSelect();
        if (select.sIntoTable == null) {
            return select.getResult(this.cChannel.getMaxRows());
        }
        Result result = select.getResult(0);
        Table table = new Table(this.dDatabase, true, select.sIntoTable, false);
        table.addColumns(result);
        table.createPrimaryKey();
        table.insert(result, this.cChannel);
        this.dDatabase.linkTable(table);
        int n = result.getSize();
        result = new Result();
        result.iUpdateCount = n;
        return result;
    }

    Result processCall() throws SQLException {
        Expression expression = this.parseExpression();
        expression.resolve(null);
        int n = expression.getDataType();
        Object object = expression.getValue();
        Result result = new Result(1);
        result.iType[0] = n;
        result.sLabel[0] = "";
        result.sName[0] = "";
        Object[] objectArray = new Object[]{object};
        result.add(objectArray);
        return result;
    }

    Result processUpdate() throws SQLException {
        Result result;
        Object object;
        String string = this.tTokenizer.getString();
        this.cChannel.checkReadWrite();
        this.cChannel.check(string, 8);
        Table table = this.dDatabase.getTable(string, this.cChannel);
        TableFilter tableFilter = new TableFilter(table, null, false);
        this.tTokenizer.getThis("SET");
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Expression> vector2 = new Vector<Expression>();
        int n = 0;
        string = null;
        do {
            ++n;
            int n2 = table.getColumnNr(this.tTokenizer.getString());
            vector.addElement(new Integer(n2));
            this.tTokenizer.getThis("=");
            object = this.parseExpression();
            ((Expression)object).resolve(tableFilter);
            vector2.addElement((Expression)object);
        } while ((string = this.tTokenizer.getString()).equals(","));
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
            expression.resolve(tableFilter);
            tableFilter.setCondition(expression);
        } else {
            this.tTokenizer.back();
        }
        object = new int[n];
        Expression[] expressionArray = new Expression[n];
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            object[n3] = (Integer)vector.elementAt(n3);
            expressionArray[n3] = (Expression)vector2.elementAt(n3);
            nArray[n3] = table.getType((int)object[n3]);
            ++n3;
        }
        n3 = 0;
        if (tableFilter.findFirst()) {
            Object object2;
            Object object3;
            result = new Result();
            Result result2 = new Result();
            int n4 = table.getColumnCount();
            do {
                if (expression != null && !expression.test()) continue;
                object3 = tableFilter.oCurrentData;
                result.add((Object[])object3);
                object2 = table.getNewRow();
                int n5 = 0;
                while (n5 < n4) {
                    object2[n5] = object3[n5];
                    ++n5;
                }
                n5 = 0;
                while (n5 < n) {
                    object2[object[n5]] = expressionArray[n5].getValue(nArray[n5]);
                    ++n5;
                }
                result2.add((Object[])object2);
            } while (tableFilter.next());
            this.cChannel.beginNestedTransaction();
            try {
                object3 = result.rRoot;
                while (object3 != null) {
                    table.deleteNoCheck(object3.data, this.cChannel);
                    object3 = object3.next;
                }
                object2 = result2.rRoot;
                while (object2 != null) {
                    table.insertNoCheck(object2.data, this.cChannel);
                    object2 = object2.next;
                    ++n3;
                }
                table.checkUpdate((int[])object, result, result2);
                this.cChannel.endNestedTransaction(false);
            }
            catch (SQLException sQLException) {
                this.cChannel.endNestedTransaction(true);
                throw sQLException;
            }
        }
        result = new Result();
        result.iUpdateCount = n3;
        return result;
    }

    Result processDelete() throws SQLException {
        Result result;
        this.tTokenizer.getThis("FROM");
        String string = this.tTokenizer.getString();
        this.cChannel.checkReadWrite();
        this.cChannel.check(string, 2);
        Table table = this.dDatabase.getTable(string, this.cChannel);
        TableFilter tableFilter = new TableFilter(table, null, false);
        string = this.tTokenizer.getString();
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
            expression.resolve(tableFilter);
            tableFilter.setCondition(expression);
        } else {
            this.tTokenizer.back();
        }
        int n = 0;
        if (tableFilter.findFirst()) {
            result = new Result();
            do {
                if (expression != null && !expression.test()) continue;
                result.add(tableFilter.oCurrentData);
            } while (tableFilter.next());
            Record record = result.rRoot;
            while (record != null) {
                table.delete(record.data, this.cChannel);
                ++n;
                record = record.next;
            }
        }
        result = new Result();
        result.iUpdateCount = n;
        return result;
    }

    Result processInsert() throws SQLException {
        Object object;
        int n;
        this.tTokenizer.getThis("INTO");
        String string = this.tTokenizer.getString();
        this.cChannel.checkReadWrite();
        this.cChannel.check(string, 4);
        Table table = this.dDatabase.getTable(string, this.cChannel);
        string = this.tTokenizer.getString();
        Vector<String> vector = null;
        if (string.equals("(")) {
            block15: {
                vector = new Vector<String>();
                n = 0;
                do {
                    vector.addElement(this.tTokenizer.getString());
                    ++n;
                    string = this.tTokenizer.getString();
                    if (string.equals(")")) break block15;
                } while (string.equals(","));
                throw Trace.error(10, string);
            }
            string = this.tTokenizer.getString();
        }
        n = 0;
        int n2 = vector == null ? table.getColumnCount() : vector.size();
        if (string.equals("VALUES")) {
            block16: {
                this.tTokenizer.getThis("(");
                object = table.getNewRow();
                int n3 = 0;
                do {
                    int n4;
                    if (vector == null) {
                        n4 = n3;
                        if (n3 > n2) {
                            throw Trace.error(4);
                        }
                    } else {
                        n4 = table.getColumnNr((String)vector.elementAt(n3));
                    }
                    object[n4] = this.getValue(table.getType(n4));
                    ++n3;
                    string = this.tTokenizer.getString();
                    if (string.equals(")")) break block16;
                } while (string.equals(","));
                throw Trace.error(10, string);
            }
            table.insert((Object[])object, this.cChannel);
            n = 1;
        } else if (string.equals("SELECT")) {
            int n5;
            object = this.processSelect();
            Record record = ((Result)object).rRoot;
            Trace.check(n2 == ((Result)object).getColumnCount(), 4);
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            int n6 = 0;
            while (n6 < n2) {
                n5 = vector == null ? n6 : table.getColumnNr((String)vector.elementAt(n6));
                nArray[n6] = n5;
                nArray2[n6] = table.getType(n5);
                ++n6;
            }
            this.cChannel.beginNestedTransaction();
            try {
                while (record != null) {
                    Object[] objectArray = table.getNewRow();
                    n5 = 0;
                    while (n5 < n2) {
                        objectArray[nArray[n5]] = Column.convertObject(record.data[n5], nArray2[n5]);
                        ++n5;
                    }
                    table.insert(objectArray, this.cChannel);
                    ++n;
                    record = record.next;
                }
                this.cChannel.endNestedTransaction(false);
            }
            catch (SQLException sQLException) {
                this.cChannel.endNestedTransaction(true);
                throw sQLException;
            }
        } else {
            throw Trace.error(10, string);
        }
        object = new Result();
        ((Result)object).iUpdateCount = n;
        return object;
    }

    private Select parseSelect() throws SQLException {
        Object object;
        int n;
        Object object2;
        Expression expression;
        Select select = new Select();
        String string = this.tTokenizer.getString();
        if (string.equals("DISTINCT")) {
            select.bDistinct = true;
        } else {
            this.tTokenizer.back();
        }
        Vector<Expression> vector = new Vector<Expression>();
        do {
            expression = this.parseExpression();
            string = this.tTokenizer.getString();
            if (string.equals("AS")) {
                expression.setAlias(this.tTokenizer.getName());
                string = this.tTokenizer.getString();
            } else if (this.tTokenizer.wasName()) {
                expression.setAlias(string);
                string = this.tTokenizer.getString();
            }
            vector.addElement(expression);
        } while (string.equals(","));
        if (string.equals("INTO")) {
            select.sIntoTable = this.tTokenizer.getString();
            string = this.tTokenizer.getString();
        }
        if (!string.equals("FROM")) {
            throw Trace.error(10, string);
        }
        expression = null;
        Vector<TableFilter> vector2 = new Vector<TableFilter>();
        vector2.addElement(this.parseTableFilter(false));
        while (true) {
            if ((string = this.tTokenizer.getString()).equals("LEFT")) {
                string = this.tTokenizer.getString();
                if (string.equals("OUTER")) {
                    string = this.tTokenizer.getString();
                }
                Trace.check(string.equals("JOIN"), 10, string);
                vector2.addElement(this.parseTableFilter(true));
                this.tTokenizer.getThis("ON");
                expression = this.addCondition(expression, this.parseExpression());
                continue;
            }
            if (string.equals("INNER")) {
                this.tTokenizer.getThis("JOIN");
                vector2.addElement(this.parseTableFilter(false));
                this.tTokenizer.getThis("ON");
                expression = this.addCondition(expression, this.parseExpression());
                continue;
            }
            if (!string.equals(",")) break;
            vector2.addElement(this.parseTableFilter(false));
        }
        this.tTokenizer.back();
        int n2 = vector2.size();
        TableFilter[] tableFilterArray = new TableFilter[n2];
        int n3 = 0;
        while (n3 < n2) {
            tableFilterArray[n3] = (TableFilter)vector2.elementAt(n3);
            ++n3;
        }
        select.tFilter = tableFilterArray;
        n2 = vector.size();
        n3 = 0;
        while (n3 < n2) {
            object2 = (Expression)vector.elementAt(n3);
            if (((Expression)object2).getType() == 6) {
                n = n3;
                object = null;
                String string2 = ((Expression)object2).getTableName();
                int n4 = 0;
                while (n4 < tableFilterArray.length) {
                    TableFilter tableFilter = tableFilterArray[n4];
                    ((Expression)object2).resolve(tableFilter);
                    if (string2 == null || string2.equals(tableFilter.getName())) {
                        object = tableFilter.getTable();
                        int n5 = ((Table)object).getColumnCount();
                        int n6 = 0;
                        while (n6 < n5) {
                            Expression expression2 = new Expression(tableFilter.getName(), ((Table)object).getColumnName(n6));
                            vector.insertElementAt(expression2, n++);
                            ++n2;
                            ++n6;
                        }
                    }
                    ++n4;
                }
                Trace.check(object != null, 21, string2);
                --n2;
                vector.removeElementAt(n);
            }
            ++n3;
        }
        select.iResultLen = n2;
        string = this.tTokenizer.getString();
        if (string.equals("WHERE")) {
            expression = this.addCondition(expression, this.parseExpression());
            string = this.tTokenizer.getString();
        }
        select.eCondition = expression;
        if (string.equals("GROUP")) {
            this.tTokenizer.getThis("BY");
            n2 = 0;
            do {
                vector.addElement(this.parseExpression());
                string = this.tTokenizer.getString();
                ++n2;
            } while (string.equals(","));
            select.iGroupLen = n2;
        }
        if (string.equals("ORDER")) {
            this.tTokenizer.getThis("BY");
            n2 = 0;
            do {
                Object object3;
                if (((Expression)(object3 = this.parseExpression())).getType() == 1) {
                    if (((Expression)object3).getDataType() == 4) {
                        int n7 = (Integer)((Expression)object3).getValue();
                        object3 = (Expression)vector.elementAt(n7 - 1);
                    }
                } else if (((Expression)object3).getType() == 2 && ((Expression)object3).getTableName() == null) {
                    object2 = ((Expression)object3).getColumnName();
                    n = 0;
                    while (n < vector.size()) {
                        object = (Expression)vector.elementAt(n);
                        if (((String)object2).equals(((Expression)object).getAlias())) {
                            object3 = object;
                            break;
                        }
                        ++n;
                    }
                }
                string = this.tTokenizer.getString();
                if (string.equals("DESC")) {
                    ((Expression)object3).setDescending();
                    string = this.tTokenizer.getString();
                } else if (string.equals("ASC")) {
                    string = this.tTokenizer.getString();
                }
                vector.addElement((Expression)object3);
                ++n2;
            } while (string.equals(","));
            select.iOrderLen = n2;
        }
        n2 = vector.size();
        select.eColumn = new Expression[n2];
        int n8 = 0;
        while (n8 < n2) {
            select.eColumn[n8] = (Expression)vector.elementAt(n8);
            ++n8;
        }
        if (string.equals("UNION")) {
            string = this.tTokenizer.getString();
            if (string.equals("ALL")) {
                select.iUnionType = 2;
            } else {
                select.iUnionType = 1;
                this.tTokenizer.back();
            }
            this.tTokenizer.getThis("SELECT");
            select.sUnion = this.parseSelect();
        } else if (string.equals("INTERSECT")) {
            this.tTokenizer.getThis("SELECT");
            select.iUnionType = 3;
            select.sUnion = this.parseSelect();
        } else if (string.equals("EXCEPT") || string.equals("MINUS")) {
            this.tTokenizer.getThis("SELECT");
            select.iUnionType = 4;
            select.sUnion = this.parseSelect();
        } else {
            this.tTokenizer.back();
        }
        return select;
    }

    private TableFilter parseTableFilter(boolean bl) throws SQLException {
        Object object;
        String string = this.tTokenizer.getString();
        Table table = null;
        if (string.equals("(")) {
            this.tTokenizer.getThis("SELECT");
            object = this.parseSelect();
            Result result = ((Select)object).getResult(0);
            table = new Table(this.dDatabase, false, "SYSTEM_SUBQUERY", false);
            this.tTokenizer.getThis(")");
            table.addColumns(result);
            table.createPrimaryKey();
            table.insert(result, this.cChannel);
        } else {
            this.cChannel.check(string, 1);
            table = this.dDatabase.getTable(string, this.cChannel);
        }
        object = null;
        string = this.tTokenizer.getString();
        if (string.equals("AS")) {
            object = this.tTokenizer.getName();
        } else if (this.tTokenizer.wasName()) {
            object = string;
        } else {
            this.tTokenizer.back();
        }
        return new TableFilter(table, (String)object, bl);
    }

    private Expression addCondition(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        return new Expression(28, expression, expression2);
    }

    private Object getValue(int n) throws SQLException {
        Expression expression = this.parseExpression();
        expression.resolve(null);
        return expression.getValue(n);
    }

    private Expression parseExpression() throws SQLException {
        this.read();
        if (this.iToken == 42 || this.iToken == 43 || this.iToken == 40 || this.iToken == 41 || this.iToken == 44) {
            int n = this.iToken;
            this.read();
            Expression expression = new Expression(n, this.readOr(), null);
            this.tTokenizer.back();
            return expression;
        }
        Expression expression = this.readOr();
        this.tTokenizer.back();
        return expression;
    }

    private Expression readOr() throws SQLException {
        Expression expression = this.readAnd();
        while (this.iToken == 29) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readAnd());
        }
        return expression;
    }

    private Expression readAnd() throws SQLException {
        Expression expression = this.readCondition();
        while (this.iToken == 28) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readCondition());
        }
        return expression;
    }

    private Expression readCondition() throws SQLException {
        if (this.iToken == 20) {
            int n = this.iToken;
            this.read();
            return new Expression(n, this.readCondition(), null);
        }
        if (this.iToken == 31) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            Trace.check(this.iToken == 103, 10);
            Expression expression = new Expression(this.parseSelect());
            this.read();
            this.readThis(102);
            return new Expression(n, expression, null);
        }
        Expression expression = this.readConcat();
        boolean bl = false;
        if (this.iToken == 20) {
            bl = true;
            this.read();
        }
        if (this.iToken == 27) {
            this.read();
            Expression expression2 = this.readConcat();
            char c = '\u0000';
            if (this.sToken.equals("ESCAPE")) {
                this.read();
                Expression expression3 = this.readTerm();
                Trace.check(expression3.getType() == 1, 6);
                String string = (String)expression3.getValue(12);
                if (string == null || string.length() < 1) {
                    throw Trace.error(6, string);
                }
                c = string.charAt(0);
            }
            expression = new Expression(27, expression, expression2);
            expression.setLikeEscape(c);
        } else if (this.iToken == 106) {
            this.read();
            Expression expression4 = new Expression(22, expression, this.readConcat());
            this.readThis(28);
            Expression expression5 = new Expression(25, expression, this.readConcat());
            expression = new Expression(28, expression4, expression5);
        } else if (this.iToken == 30) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            Expression expression6 = null;
            if (this.iToken == 103) {
                expression6 = new Expression(this.parseSelect());
                this.read();
            } else if (this.iToken == 1) {
                Vector<Object> vector = new Vector<Object>();
                while (true) {
                    vector.addElement(Column.convertObject(this.oData, 12));
                    this.read();
                    if (this.iToken != 104) break;
                    this.read();
                }
                expression6 = new Expression(vector);
            }
            this.readThis(102);
            expression = new Expression(n, expression, expression6);
        } else {
            Trace.check(!bl, 10);
            if (Expression.isCompare(this.iToken)) {
                int n = this.iToken;
                this.read();
                return new Expression(n, expression, this.readConcat());
            }
            return expression;
        }
        if (bl) {
            expression = new Expression(20, expression, null);
        }
        return expression;
    }

    private void readThis(int n) throws SQLException {
        Trace.check(this.iToken == n, 10);
        this.read();
    }

    private Expression readConcat() throws SQLException {
        Expression expression = this.readSum();
        while (this.iToken == 105) {
            int n = 15;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readSum());
        }
        return expression;
    }

    private Expression readSum() throws SQLException {
        Expression expression = this.readFactor();
        while (true) {
            int n;
            if (this.iToken == 100) {
                n = 10;
            } else {
                if (this.iToken != 9) break;
                n = 11;
            }
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readFactor());
        }
        return expression;
    }

    private Expression readFactor() throws SQLException {
        Expression expression = this.readTerm();
        while (this.iToken == 12 || this.iToken == 14) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readTerm());
        }
        return expression;
    }

    private Expression readTerm() throws SQLException {
        Expression expression = null;
        if (this.iToken == 2) {
            String string = this.sToken;
            expression = new Expression(this.sTable, this.sToken);
            this.read();
            if (this.iToken == 101) {
                Function function = new Function(this.dDatabase.getAlias(string), this.cChannel);
                int n = function.getArgCount();
                int n2 = 0;
                this.read();
                if (this.iToken != 102) {
                    while (true) {
                        function.setArgument(n2++, this.readOr());
                        if (this.iToken != 104) break;
                        this.read();
                    }
                }
                this.readThis(102);
                expression = new Expression(function);
            }
        } else if (this.iToken == 9) {
            int n = this.iToken;
            this.read();
            expression = new Expression(n, this.readTerm(), null);
        } else if (this.iToken == 100) {
            this.read();
            expression = this.readTerm();
        } else if (this.iToken == 101) {
            this.read();
            expression = this.readOr();
            if (this.iToken != 102) {
                throw Trace.error(10, this.sToken);
            }
            this.read();
        } else if (this.iToken == 1) {
            expression = new Expression(this.iType, this.oData);
            this.read();
        } else if (this.iToken == 103) {
            expression = new Expression(this.parseSelect());
            this.read();
        } else if (this.iToken == 12) {
            expression = new Expression(this.sTable, null);
            this.read();
        } else if (this.iToken == 60 || this.iToken == 15) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            expression = new Expression(n, expression, this.readOr());
            this.readThis(102);
        } else if (this.iToken == 62) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            Expression expression2 = this.readOr();
            this.readThis(104);
            expression2 = new Expression(n, expression2, this.readOr());
            expression = new Expression(n, expression, expression2);
            this.readThis(102);
        } else if (this.iToken == 61) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            int n3 = Column.getTypeNr(this.sToken);
            expression = new Expression(n, expression, null);
            expression.setDataType(n3);
            this.read();
            this.readThis(102);
        } else if (this.iToken == 107) {
            this.read();
            this.readThis(101);
            expression = this.readOr();
            Trace.check(this.sToken.equals("AS"), 10, this.sToken);
            this.read();
            int n = Column.getTypeNr(this.sToken);
            expression = new Expression(61, expression, null);
            expression.setDataType(n);
            this.read();
            this.readThis(102);
        } else {
            throw Trace.error(10, this.sToken);
        }
        return expression;
    }

    private void read() throws SQLException {
        this.sToken = this.tTokenizer.getString();
        if (this.tTokenizer.wasValue()) {
            this.iToken = 1;
            this.oData = this.tTokenizer.getAsValue();
            this.iType = this.tTokenizer.getType();
        } else if (this.tTokenizer.wasName()) {
            this.iToken = 2;
            this.sTable = null;
        } else if (this.tTokenizer.wasLongName()) {
            this.sTable = this.tTokenizer.getLongNameFirst();
            this.sToken = this.tTokenizer.getLongNameLast();
            this.iToken = this.sToken.equals("*") ? 12 : 2;
        } else if (this.sToken.equals("")) {
            this.iToken = 108;
        } else if (this.sToken.equals("AND")) {
            this.iToken = 28;
        } else if (this.sToken.equals("OR")) {
            this.iToken = 29;
        } else if (this.sToken.equals("NOT")) {
            this.iToken = 20;
        } else if (this.sToken.equals("IN")) {
            this.iToken = 30;
        } else if (this.sToken.equals("EXISTS")) {
            this.iToken = 31;
        } else if (this.sToken.equals("BETWEEN")) {
            this.iToken = 106;
        } else if (this.sToken.equals("+")) {
            this.iToken = 100;
        } else if (this.sToken.equals("-")) {
            this.iToken = 9;
        } else if (this.sToken.equals("*")) {
            this.iToken = 12;
            this.sTable = null;
        } else if (this.sToken.equals("/")) {
            this.iToken = 14;
        } else if (this.sToken.equals("||")) {
            this.iToken = 105;
        } else if (this.sToken.equals("(")) {
            this.iToken = 101;
        } else if (this.sToken.equals(")")) {
            this.iToken = 102;
        } else if (this.sToken.equals("SELECT")) {
            this.iToken = 103;
        } else if (this.sToken.equals("<")) {
            this.iToken = 24;
        } else if (this.sToken.equals("<=")) {
            this.iToken = 25;
        } else if (this.sToken.equals(">=")) {
            this.iToken = 22;
        } else if (this.sToken.equals(">")) {
            this.iToken = 23;
        } else if (this.sToken.equals("=")) {
            this.iToken = 21;
        } else if (this.sToken.equals("IS")) {
            this.sToken = this.tTokenizer.getString();
            if (this.sToken.equals("NOT")) {
                this.iToken = 26;
            } else {
                this.iToken = 21;
                this.tTokenizer.back();
            }
        } else {
            this.iToken = this.sToken.equals("<>") || this.sToken.equals("!=") ? 26 : (this.sToken.equals("LIKE") ? 27 : (this.sToken.equals("COUNT") ? 40 : (this.sToken.equals("SUM") ? 41 : (this.sToken.equals("MIN") ? 42 : (this.sToken.equals("MAX") ? 43 : (this.sToken.equals("AVG") ? 44 : (this.sToken.equals("IFNULL") ? 60 : (this.sToken.equals("CONVERT") ? 61 : (this.sToken.equals("CAST") ? 107 : (this.sToken.equals("CASEWHEN") ? 62 : (this.sToken.equals(",") ? 104 : 108)))))))))));
        }
    }

    Parser(Database database, Tokenizer tokenizer, Channel channel) {
        this.dDatabase = database;
        this.tTokenizer = tokenizer;
        this.cChannel = channel;
    }
}

